/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.ultimates.silenceult;

import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.ultimates.silenceult.SilenceTransformAnimations;
import MCplugin.powerTrims.ultimates.silenceult.SilenceUltAttacks;
import MCplugin.powerTrims.ultimates.silenceult.SilenceUltData;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.DisguiseConfig;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class SilenceUlt
implements Listener {
    private final JavaPlugin plugin;
    private final SilenceUltData data;
    private final SilenceTransformAnimations animations;
    private final SilenceUltAttacks attacks;
    private final NamespacedKey upgradeKey;

    public SilenceUlt(JavaPlugin plugin, NamespacedKey upgradeKey, SilenceUltData data) {
        this.plugin = plugin;
        this.data = data;
        this.animations = new SilenceTransformAnimations(plugin, this, data);
        this.attacks = new SilenceUltAttacks(plugin, this, data);
        this.upgradeKey = upgradeKey;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        this.cleanupPlayer(playerUUID);
        this.data.rage.remove(playerUUID);
        this.data.wardenBoomCooldowns.remove(playerUUID);
        this.data.deepDarkGraspCooldowns.remove(playerUUID);
        this.data.obliteratingLeapCooldowns.remove(playerUUID);
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        if (DisguiseAPI.isDisguised((Entity)player)) {
            this.revertFromWarden(player, false);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDamage(EntityDamageByEntityEvent event) {
        Player player;
        boolean rageGainApplied = false;
        Entity entity = event.getEntity();
        if (entity instanceof Player && ArmourChecking.hasFullUpgradedArmor(player = (Player)entity, TrimPattern.SILENCE, this.upgradeKey)) {
            this.addRage(player, 1.0);
            rageGainApplied = true;
        }
        if ((entity = event.getDamager()) instanceof Player && ArmourChecking.hasFullUpgradedArmor(player = (Player)entity, TrimPattern.SILENCE, this.upgradeKey) && !rageGainApplied) {
            this.addRage(player, 0.5);
        }
    }

    @EventHandler
    public void onAbilityRelatedDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (this.data.transformingPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL && this.data.leapingPlayers.contains(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHotbarChange(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        if (!player.isSneaking() || this.data.leapingPlayers.contains(player.getUniqueId())) {
            return;
        }
        int newSlot = event.getNewSlot();
        boolean isWarden = DisguiseAPI.isDisguised((Entity)player) && DisguiseAPI.getDisguise((Entity)player).getType() == DisguiseType.WARDEN;
        switch (newSlot) {
            case 0: {
                double currentRage = this.data.rage.getOrDefault(player.getUniqueId(), 0.0);
                if (!(currentRage >= 150.0) || isWarden || this.data.transformingPlayers.contains(player.getUniqueId())) break;
                this.animations.startTransformationSequence(player);
                break;
            }
            case 6: {
                if (!isWarden) break;
                this.attacks.tryUseWardenBoom(player);
                break;
            }
            case 7: {
                if (!isWarden) break;
                this.attacks.tryUseDeepDarkGrasp(player);
                break;
            }
            case 8: {
                if (!isWarden) break;
                this.attacks.tryUseObliteratingLeap(player);
            }
        }
    }

    public void addRage(Player player, double amount) {
        if (DisguiseAPI.isDisguised((Entity)player) || this.data.transformingPlayers.contains(player.getUniqueId())) {
            return;
        }
        double currentRage = this.data.rage.getOrDefault(player.getUniqueId(), 0.0);
        double newRage = Math.min(150.0, currentRage + amount);
        this.data.rage.put(player.getUniqueId(), newRage);
    }

    public void completeWardenTransformation(Player player) {
        if (!player.isOnline()) {
            return;
        }
        this.cleanupPlayer(player.getUniqueId());
        Location loc = player.getLocation();
        World world = loc.getWorld();
        UUID playerUUID = player.getUniqueId();
        this.data.wardenBoomCooldowns.remove(playerUUID);
        this.data.deepDarkGraspCooldowns.remove(playerUUID);
        this.data.obliteratingLeapCooldowns.remove(playerUUID);
        world.playSound(loc, Sound.ENTITY_WARDEN_ROAR, 3.0f, 1.0f);
        world.playSound(loc, Sound.ENTITY_GENERIC_EXPLODE, 2.0f, 0.8f);
        world.spawnParticle(Particle.SONIC_BOOM, loc.clone().add(0.0, 1.0, 0.0), 1);
        world.spawnParticle(Particle.EXPLOSION, loc, 5);
        for (Entity entity : world.getNearbyEntities(loc, 10.0, 10.0, 10.0)) {
            if (entity.equals((Object)player) || !(entity instanceof LivingEntity)) continue;
            Vector direction = entity.getLocation().toVector().subtract(loc.toVector()).normalize();
            direction.multiply(1.5).setY(0.5);
            entity.setVelocity(direction);
        }
        for (Entity entity : world.getNearbyEntities(loc, 16.0, 16.0, 16.0)) {
            if (!(entity instanceof Player)) continue;
            Player nearbyPlayer = (Player)entity;
            nearbyPlayer.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, 100, 0));
        }
        player.sendMessage(String.valueOf(ChatColor.DARK_PURPLE) + String.valueOf(ChatColor.BOLD) + "You have embraced the deep dark!");
        MobDisguise wardenDisguise = new MobDisguise(DisguiseType.WARDEN);
        wardenDisguise.setViewSelfDisguise(true);
        wardenDisguise.setTallSelfDisguise(DisguiseConfig.TallSelfDisguise.HIDDEN);
        DisguiseConfig.setNotifyBar((DisguiseConfig.NotifyBar)DisguiseConfig.NotifyBar.NONE);
        DisguiseAPI.disguiseToAll((Entity)player, (Disguise)wardenDisguise);
        long durationTicks = 800L;
        player.addPotionEffect(new PotionEffect(PotionEffectType.HEALTH_BOOST, (int)durationTicks, 4, false, false));
        player.addPotionEffect(new PotionEffect(PotionEffectType.STRENGTH, (int)durationTicks, 2, false, false));
        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, (int)durationTicks, 1, false, false));
        this.startWardenTimer(player);
    }

    public void revertFromWarden(Player player, boolean sendMessage) {
        this.cleanupPlayer(player.getUniqueId());
        if (sendMessage) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "The Warden's power recedes...");
        }
        UUID playerUUID = player.getUniqueId();
        this.data.wardenBoomCooldowns.remove(playerUUID);
        this.data.deepDarkGraspCooldowns.remove(playerUUID);
        this.data.obliteratingLeapCooldowns.remove(playerUUID);
        if (DisguiseAPI.isDisguised((Entity)player)) {
            DisguiseAPI.undisguiseToAll((Entity)player);
        }
        player.removePotionEffect(PotionEffectType.STRENGTH);
        player.removePotionEffect(PotionEffectType.RESISTANCE);
        player.removePotionEffect(PotionEffectType.HEALTH_BOOST);
    }

    public void startWardenTimer(final Player player) {
        final UUID playerUUID = player.getUniqueId();
        final long transformEndTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(40L);
        this.data.wardenEndTimes.put(playerUUID, transformEndTime);
        BukkitTask task = new BukkitRunnable(this){
            final /* synthetic */ SilenceUlt this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || !this.this$0.data.wardenEndTimes.containsKey(playerUUID)) {
                    this.this$0.revertFromWarden(player, true);
                    this.cancel();
                    return;
                }
                if (System.currentTimeMillis() > transformEndTime) {
                    this.this$0.revertFromWarden(player, true);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        this.data.wardenTimers.put(player.getUniqueId(), task);
    }

    public String getUltimateActionbarString(Player player) {
        boolean isWarden;
        UUID playerUUID = player.getUniqueId();
        boolean bl = isWarden = DisguiseAPI.isDisguised((Entity)player) && DisguiseAPI.getDisguise((Entity)player).getType() == DisguiseType.WARDEN;
        if (isWarden) {
            long now = System.currentTimeMillis();
            long wardenEndTime = this.data.wardenEndTimes.getOrDefault(playerUUID, 0L);
            long durationLeft = wardenEndTime - now;
            String durationStr = String.valueOf(ChatColor.DARK_PURPLE) + "Warden: " + String.valueOf(ChatColor.LIGHT_PURPLE) + (String)(durationLeft > 0L ? durationLeft / 1000L + 1L + "s" : "Ended");
            String boomStr = this.getCooldownString("A1", 10L, this.data.wardenBoomCooldowns.get(playerUUID), now);
            String graspStr = this.getCooldownString("A2", 15L, this.data.deepDarkGraspCooldowns.get(playerUUID), now);
            String leapStr = this.getCooldownString("A3", 25L, this.data.obliteratingLeapCooldowns.get(playerUUID), now);
            return durationStr + String.valueOf(ChatColor.DARK_GRAY) + " | " + boomStr + String.valueOf(ChatColor.DARK_GRAY) + " | " + graspStr + String.valueOf(ChatColor.DARK_GRAY) + " | " + leapStr;
        }
        if (ArmourChecking.hasFullUpgradedArmor(player, TrimPattern.SILENCE, this.upgradeKey)) {
            double currentRage = this.data.rage.getOrDefault(playerUUID, 0.0);
            if (currentRage >= 150.0) {
                return String.valueOf(ChatColor.RED) + String.valueOf(ChatColor.BOLD) + "ULTIMATE READY";
            }
            int ragePercent = (int)(currentRage / 150.0 * 100.0);
            return String.valueOf(ChatColor.DARK_AQUA) + "Rage: " + String.valueOf(ChatColor.AQUA) + ragePercent + "%";
        }
        return "";
    }

    private String getCooldownString(String abilityName, long totalCooldown, Long lastUsed, long now) {
        if (lastUsed == null) {
            return String.valueOf(ChatColor.GREEN) + abilityName + ": READY";
        }
        long cooldownMillis = TimeUnit.SECONDS.toMillis(totalCooldown);
        long cooldownLeft = lastUsed + cooldownMillis - now;
        if (cooldownLeft > 0L) {
            return String.valueOf(ChatColor.YELLOW) + abilityName + ": " + String.valueOf(ChatColor.RED) + String.format("%.1f", (double)cooldownLeft / 1000.0) + "s";
        }
        return String.valueOf(ChatColor.GREEN) + abilityName + ": READY";
    }

    public void cleanupPlayer(UUID playerUUID) {
        Player p;
        SilenceUlt silenceUlt = this;
        silenceUlt.animations.revertSculkBlocks();
        this.data.originalBlocks.remove(playerUUID);
        if (this.data.sculkTasks.containsKey(playerUUID)) {
            this.data.sculkTasks.remove(playerUUID).cancel();
        }
        if (this.data.mainAnimationTasks.containsKey(playerUUID)) {
            this.data.mainAnimationTasks.remove(playerUUID).cancel();
        }
        if (this.data.transformingPlayers.remove(playerUUID) && (p = Bukkit.getPlayer((UUID)playerUUID)) != null) {
            p.resetPlayerWeather();
        }
        if (this.data.wardenTimers.containsKey(playerUUID)) {
            this.data.wardenTimers.remove(playerUUID).cancel();
        }
        this.data.wardenEndTimes.remove(playerUUID);
        this.data.leapingPlayers.remove(playerUUID);
    }
}

