/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.ultimates.silenceult;

import MCplugin.powerTrims.ultimates.silenceult.SilenceUlt;
import MCplugin.powerTrims.ultimates.silenceult.SilenceUltData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class SilenceUltAttacks {
    private final JavaPlugin plugin;
    private final SilenceUltData data;

    public SilenceUltAttacks(JavaPlugin plugin, SilenceUlt silenceUlt, SilenceUltData data) {
        this.plugin = plugin;
        this.data = data;
    }

    public void tryUseWardenBoom(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.data.chargingBoomPlayers.contains(playerUUID) || this.data.leapingPlayers.contains(playerUUID)) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "You are already performing an action!");
            return;
        }
        long currentTime = System.currentTimeMillis();
        Long lastUsed = this.data.wardenBoomCooldowns.get(playerUUID);
        long cooldownMillis = TimeUnit.SECONDS.toMillis(10L);
        if (lastUsed == null || currentTime - lastUsed >= cooldownMillis) {
            this.chargeWardenBoom(player);
        } else {
            long timeLeft = (lastUsed + cooldownMillis - currentTime) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "Sonic Boom on cooldown for " + (timeLeft + 1L) + " seconds!");
        }
    }

    private void chargeWardenBoom(final Player player) {
        final UUID playerUUID = player.getUniqueId();
        this.data.chargingBoomPlayers.add(playerUUID);
        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 105, 1, true, false));
        final ArrayList<BlockDisplay> absorbingBlocks = new ArrayList<BlockDisplay>();
        int chargeDurationTicks = 100;
        int numParticles = 30;
        double maxRadius = 5.0;
        for (int i = 0; i < 30; ++i) {
            BlockDisplay absorbingBlock = (BlockDisplay)player.getWorld().spawn(player.getEyeLocation(), BlockDisplay.class, bd -> {
                bd.setBlock(Material.SCULK.createBlockData());
                Transformation t = bd.getTransformation();
                t.getScale().set(0.25f);
                bd.setTransformation(t);
                bd.setInterpolationDuration(3);
                bd.setInterpolationDelay(-1);
            });
            absorbingBlocks.add(absorbingBlock);
        }
        new BukkitRunnable(this){
            int ticks = 0;
            final double angleStep = 0.20943951023931953;
            final /* synthetic */ SilenceUltAttacks this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || !this.this$0.data.chargingBoomPlayers.contains(playerUUID)) {
                    absorbingBlocks.forEach(Entity::remove);
                    this.this$0.data.chargingBoomPlayers.remove(playerUUID);
                    if (player.isOnline()) {
                        player.sendTitle("", "", 0, 1, 0);
                    }
                    this.cancel();
                    return;
                }
                Location center = player.getEyeLocation();
                if (this.ticks >= 100) {
                    this.this$0.fireWardenBoom(player);
                    this.this$0.data.wardenBoomCooldowns.put(playerUUID, System.currentTimeMillis());
                    this.this$0.data.chargingBoomPlayers.remove(playerUUID);
                    absorbingBlocks.forEach(Entity::remove);
                    player.sendTitle("", "", 0, 1, 0);
                    this.cancel();
                    return;
                }
                int chargePercentage = (int)((double)this.ticks / 100.0 * 100.0);
                player.sendTitle(String.valueOf(ChatColor.DARK_AQUA) + "\u00a7lSonic Boom", String.valueOf(ChatColor.AQUA) + "Charging: " + chargePercentage + "%", 0, 10, 5);
                double currentRadius = 5.0 * (1.0 - (double)this.ticks / 100.0);
                double rotation = (double)this.ticks * 0.1;
                for (int i = 0; i < absorbingBlocks.size(); ++i) {
                    BlockDisplay block = (BlockDisplay)absorbingBlocks.get(i);
                    if (!block.isValid()) continue;
                    double angle = (double)i * 0.20943951023931953 + rotation;
                    double yOffset = Math.sin((double)(this.ticks + i * 5) * 0.2) * 0.5;
                    Vector offset = new Vector(Math.cos(angle) * currentRadius, yOffset, Math.sin(angle) * currentRadius);
                    block.teleport(center.clone().add(offset));
                }
                if (this.ticks == 0) {
                    player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WARDEN_SONIC_CHARGE, 1.5f, 1.0f);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void fireWardenBoom(Player player) {
        final Location startLoc = player.getEyeLocation();
        final Vector direction = startLoc.getDirection();
        final World world = startLoc.getWorld();
        world.playSound(startLoc, Sound.ENTITY_WARDEN_SONIC_BOOM, 2.0f, 1.0f);
        HashSet entitiesToDamage = new HashSet();
        for (double i = 1.0; i < 20.0; i += 1.0) {
            Location point = startLoc.clone().add(direction.clone().multiply(i));
            entitiesToDamage.addAll(world.getNearbyLivingEntities(point, 3.0));
        }
        entitiesToDamage.remove(player);
        for (LivingEntity victim : entitiesToDamage) {
            double newHealth = Math.max(0.0, victim.getHealth() - 12.0);
            victim.setHealth(newHealth);
            victim.damage(0.0, (Entity)player);
        }
        new BukkitRunnable(this){
            double distance = 0.0;

            public void run() {
                if (this.distance > 20.0) {
                    this.cancel();
                    return;
                }
                Location particleLoc = startLoc.clone().add(direction.clone().multiply(this.distance));
                world.spawnParticle(Particle.SONIC_BOOM, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                this.distance += 1.5;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void tryUseDeepDarkGrasp(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.data.chargingBoomPlayers.contains(playerUUID)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are charging a Sonic Boom!");
            return;
        }
        long currentTime = System.currentTimeMillis();
        Long lastUsed = this.data.deepDarkGraspCooldowns.get(playerUUID);
        long cooldownMillis = TimeUnit.SECONDS.toMillis(15L);
        if (lastUsed == null || currentTime - lastUsed >= cooldownMillis) {
            this.deepDarkGrasp(player);
            this.data.deepDarkGraspCooldowns.put(playerUUID, currentTime);
        } else {
            long timeLeft = (lastUsed + cooldownMillis - currentTime) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "Deep Dark Grasp is on cooldown for " + (timeLeft + 1L) + " seconds!");
        }
    }

    private void deepDarkGrasp(Player player) {
        Location center = player.getLocation();
        World world = center.getWorld();
        world.playSound(center, Sound.ENTITY_WARDEN_TENDRIL_CLICKS, 2.0f, 0.5f);
        world.playSound(center, Sound.BLOCK_SCULK_SHRIEKER_SHRIEK, 2.0f, 2.0f);
        world.spawnParticle(Particle.SCULK_CHARGE_POP, center.clone().add(0.0, 1.0, 0.0), 30, 0.5, 0.5, 0.5, 0.0);
        for (Entity entity : world.getNearbyEntities(center, 25.0, 25.0, 25.0)) {
            if (!(entity instanceof LivingEntity) || entity.equals((Object)player)) continue;
            this.playGraspingTentacle(player, (LivingEntity)entity);
        }
    }

    private void playGraspingTentacle(final Player player, final LivingEntity target) {
        int extendTicks = 15;
        int pullTicks = 40;
        final ArrayList<BlockDisplay> tendrilLinks = new ArrayList<BlockDisplay>();
        double distance = player.getLocation().distance(target.getLocation());
        int segmentCount = (int)(distance * 2.0);
        for (int i = 0; i < segmentCount; ++i) {
            BlockDisplay link = (BlockDisplay)player.getWorld().spawn(player.getEyeLocation(), BlockDisplay.class, bd -> {
                bd.setBlock(Material.SCULK.createBlockData());
                bd.setInterpolationDuration(2);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(0.3f);
                bd.setTransformation(t);
            });
            tendrilLinks.add(link);
        }
        new BukkitRunnable(this){
            private int ticks = 0;

            public void run() {
                if (this.ticks++ >= 55 || !player.isValid() || !target.isValid() || target.isDead()) {
                    this.cancel();
                    tendrilLinks.forEach(Entity::remove);
                    return;
                }
                Location playerAnchor = player.getEyeLocation().add(0.0, -0.5, 0.0);
                Location targetAnchor = target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0);
                if (this.ticks <= 15) {
                    double extendProgress = (double)this.ticks / 15.0;
                    Vector toTarget = targetAnchor.toVector().subtract(playerAnchor.toVector());
                    for (int i = 0; i < tendrilLinks.size(); ++i) {
                        BlockDisplay link = (BlockDisplay)tendrilLinks.get(i);
                        if (!link.isValid()) continue;
                        double progress = (double)i / (double)(tendrilLinks.size() - 1);
                        Location linkPos = playerAnchor.clone().add(toTarget.clone().multiply(progress * extendProgress));
                        link.teleport(linkPos);
                    }
                } else {
                    Vector pullDirection = playerAnchor.toVector().subtract(targetAnchor.toVector()).normalize();
                    target.setVelocity(pullDirection.multiply(2.0));
                    Vector toTarget = targetAnchor.toVector().subtract(playerAnchor.toVector());
                    for (int i = 0; i < tendrilLinks.size(); ++i) {
                        BlockDisplay link = (BlockDisplay)tendrilLinks.get(i);
                        if (!link.isValid()) continue;
                        double progress = (double)i / (double)Math.max(1, tendrilLinks.size() - 1);
                        Location linkPos = playerAnchor.clone().add(toTarget.clone().multiply(progress));
                        link.teleport(linkPos);
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void tryUseObliteratingLeap(Player player) {
        UUID playerUUID = player.getUniqueId();
        if (this.data.chargingBoomPlayers.contains(playerUUID)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are charging a Sonic Boom!");
            return;
        }
        long currentTime = System.currentTimeMillis();
        Long lastUsed = this.data.obliteratingLeapCooldowns.get(playerUUID);
        long cooldownMillis = TimeUnit.SECONDS.toMillis(25L);
        if (lastUsed == null || currentTime - lastUsed >= cooldownMillis) {
            this.obliteratingLeap(player);
            this.data.obliteratingLeapCooldowns.put(playerUUID, currentTime);
        } else {
            long timeLeft = (lastUsed + cooldownMillis - currentTime) / 1000L;
            player.sendMessage(String.valueOf(ChatColor.RED) + "Obliterating Leap is on cooldown for " + (timeLeft + 1L) + " seconds!");
        }
    }

    private void obliteratingLeap(final Player player) {
        this.data.leapingPlayers.add(player.getUniqueId());
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WARDEN_AGITATED, 2.0f, 0.5f);
        player.setVelocity(new Vector(0.0, 1.8, 0.0));
        new BukkitRunnable(this){
            boolean isFalling = false;
            int ticksLived = 0;
            final /* synthetic */ SilenceUltAttacks this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                ++this.ticksLived;
                if (!player.isOnline() || !this.this$0.data.leapingPlayers.contains(player.getUniqueId()) || this.ticksLived > 200) {
                    this.cancel();
                    this.this$0.data.leapingPlayers.remove(player.getUniqueId());
                    return;
                }
                if (player.getVelocity().getY() > 0.0) {
                    player.getWorld().spawnParticle(Particle.REVERSE_PORTAL, player.getLocation(), 5, 0.2, 0.2, 0.2, 0.01);
                } else {
                    player.getWorld().spawnParticle(Particle.SMOKE, player.getLocation(), 5, 0.2, 0.2, 0.2, 0.0);
                }
                if (!this.isFalling && player.getVelocity().getY() < 0.0) {
                    this.isFalling = true;
                    player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WARDEN_ROAR, 2.0f, 1.5f);
                }
                if (this.isFalling) {
                    player.setVelocity(player.getVelocity().add(new Vector(0.0, -0.15, 0.0)));
                }
                if (this.isFalling && (player.isOnGround() || player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType().isSolid())) {
                    this.cancel();
                    this.this$0.data.leapingPlayers.remove(player.getUniqueId());
                    final Location groundLoc = player.getLocation();
                    final World world = groundLoc.getWorld();
                    world.createExplosion((Entity)player, groundLoc, 10.0f, true, true);
                    new BukkitRunnable(this){
                        double radius = 0.0;

                        public void run() {
                            if (this.radius >= 12.0) {
                                this.cancel();
                                return;
                            }
                            this.radius += 0.75;
                            for (int i = 0; i < 360; i += 10) {
                                double angle = Math.toRadians(i);
                                double x = Math.cos(angle) * this.radius;
                                double z = Math.sin(angle) * this.radius;
                                Location particleLoc = groundLoc.clone().add(x, 0.2, z);
                                world.spawnParticle(Particle.BLOCK, particleLoc, 10, 0.5, 0.1, 0.5, 0.0, (Object)Bukkit.createBlockData((Material)Material.DEEPSLATE));
                            }
                        }
                    }.runTaskTimer((Plugin)this.this$0.plugin, 0L, 1L);
                    for (Entity entity : world.getNearbyEntities(groundLoc, 12.0, 12.0, 12.0)) {
                        if (!(entity instanceof LivingEntity) || entity.equals((Object)player)) continue;
                        Vector knockback = entity.getLocation().toVector().subtract(groundLoc.toVector()).normalize();
                        entity.setVelocity(knockback.multiply(2.0).setY(0.5));
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }
}

