/*
 * Decompiled with CFR 0.152.
 */
package fun.yak.advancedChatOptimizer;

import fun.yak.advancedChatOptimizer.AdvancedChatOptimizer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    private final AdvancedChatOptimizer plugin;

    public ChatListener(AdvancedChatOptimizer plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String message = event.getMessage();
        event.setCancelled(true);
        FileConfiguration cfg = this.plugin.getConfig();
        Bukkit.broadcastMessage((String)(this.getCurrentDimension(event.getPlayer()) + " " + event.getPlayer().getName() + ": " + ChatColor.translateAlternateColorCodes((char)'&', (String)message)));
    }

    public String getCurrentDimension(Player player) {
        World world = player.getWorld();
        String worldName = world.getName();
        FileConfiguration config = this.plugin.getConfig();
        Integer lang = config.getInt("language");
        this.plugin.getLogger().info("get configured language" + lang);
        if (lang == 2) {
            if (worldName.equalsIgnoreCase("world")) {
                return String.valueOf(ChatColor.GREEN) + "[\u4e3b\u4e16\u754c]" + String.valueOf(ChatColor.WHITE);
            }
            if (worldName.equalsIgnoreCase("world_nether")) {
                return String.valueOf(ChatColor.RED) + "[\u5730\u72f1]" + String.valueOf(ChatColor.WHITE);
            }
            if (worldName.equalsIgnoreCase("world_the_end")) {
                return String.valueOf(ChatColor.YELLOW) + "[\u672b\u5730]" + String.valueOf(ChatColor.WHITE);
            }
        } else {
            if (worldName.equalsIgnoreCase("world")) {
                return String.valueOf(ChatColor.GREEN) + "[Overworld]" + String.valueOf(ChatColor.WHITE);
            }
            if (worldName.equalsIgnoreCase("world_nether")) {
                return String.valueOf(ChatColor.RED) + "[Nether]" + String.valueOf(ChatColor.WHITE);
            }
            if (worldName.equalsIgnoreCase("world_the_end")) {
                return String.valueOf(ChatColor.YELLOW) + "[The End]" + String.valueOf(ChatColor.WHITE);
            }
        }
        return " ";
    }
}

