/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.mods.permissions;

import com.mojang.authlib.GameProfile;
import cyber.permissions.v1.Permission;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import me.isaiah.mods.permissions.CyberPermissionsMod;
import net.minecraft.class_3222;

public class Config {
    private File file;
    public boolean isGroup;
    public String name;
    public String uuid;
    public List<String> parentGroups = new ArrayList<String>();
    public List<String> permissions = new ArrayList<String>();
    public List<String> negPermissions = new ArrayList<String>();

    public Config(File f) throws IOException {
        this.file = f;
        if (f.exists()) {
            List<String> list = Files.readAllLines(this.file.toPath());
            String last = "";
            for (String s : list) {
                if (s.contains(":")) {
                    String start = s.split(":")[0];
                    if (start.equalsIgnoreCase("permissions")) {
                        last = start;
                    }
                    if (s.split(":").length <= 1) continue;
                    String value = s.split(":")[1].trim();
                    if (!last.equalsIgnoreCase(start)) {
                        last = "";
                    }
                    if (start.equalsIgnoreCase("name")) {
                        this.name = value;
                    }
                    if (start.equalsIgnoreCase("uuid")) {
                        this.uuid = value;
                    }
                    if (start.equalsIgnoreCase("isGroup")) {
                        this.isGroup = Boolean.valueOf(value);
                    }
                    if (start.equalsIgnoreCase("parentGroups")) {
                        String[] txt;
                        for (String group : txt = value.split(",")) {
                            this.parentGroups.add(group.trim());
                        }
                    }
                }
                if (!last.equalsIgnoreCase("permissions") || !s.startsWith("- ")) continue;
                String perm = s.substring(1).trim();
                if (perm.startsWith("-")) {
                    this.negPermissions.add(perm.substring(1).trim());
                    continue;
                }
                this.permissions.add(perm);
            }
        }
    }

    public void setPermission(Permission id, boolean value) {
        String str = id.getPermissionAsString();
        this.setPermission(str, value);
    }

    public void setPermission(String str, boolean value) {
        if (!value) {
            if (this.permissions.contains(str)) {
                this.permissions.remove(str);
            } else {
                this.negPermissions.add(str);
            }
        } else {
            this.permissions.add(str);
        }
        this.save();
    }

    public Config(class_3222 plr) throws IOException {
        this(new File(new File(CyberPermissionsMod.storage, "users"), plr.method_5667().toString() + ".yml"));
        this.name = plr.method_5477().getString();
        this.uuid = plr.method_5667().toString();
        this.isGroup = false;
        this.parentGroups.add("default");
        this.permissions.add("example.permission");
        this.write();
    }

    public Config(String group) throws IOException {
        this(new File(new File(CyberPermissionsMod.storage, "groups"), group + ".yml"));
        if (this.file.exists()) {
            return;
        }
        this.name = group;
        this.uuid = null;
        this.isGroup = true;
        if (!group.equalsIgnoreCase("default")) {
            this.parentGroups.add("default");
        }
        this.permissions.add("example.permission");
        this.write();
    }

    public Config(GameProfile profile) throws IOException {
        this(new File(new File(CyberPermissionsMod.storage, "users"), profile.id().toString() + ".yml"));
        this.name = profile.name();
        this.uuid = profile.id().toString();
        this.isGroup = false;
        this.parentGroups.add("default");
        this.permissions.add("example.permission");
        this.write();
    }

    public boolean hasPermission(String permission) {
        if (this.negPermissions.contains(permission)) {
            return false;
        }
        if (this.permissions.contains(permission)) {
            return true;
        }
        for (String s : this.parentGroups) {
            if (!CyberPermissionsMod.groups.get(s).hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public void save() {
        try {
            this.write();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write() throws IOException {
        String groups = "parentGroups: ";
        for (String s : this.parentGroups) {
            groups = groups + s + ", ";
        }
        String text = (null != this.uuid ? "uuid: " + this.uuid + "\n" : "") + "name: " + this.name + "\nisGroup: " + this.isGroup + (this.parentGroups.size() > 0 ? "\n" + groups : "") + "\npermissions:\n";
        for (String s : this.negPermissions) {
            text = text + "- -" + s;
        }
        for (String s : this.permissions) {
            text = text + "- " + s;
        }
        Files.write(this.file.toPath(), text.getBytes(), new OpenOption[0]);
    }
}

