/*
 * Decompiled with CFR 0.152.
 */
package me.isaiah.mods.permissions;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import cyber.permissions.v1.CyberPermissions;
import cyber.permissions.v1.Permissible;
import cyber.permissions.v1.Permission;
import cyber.permissions.v1.PermissionDefaults;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import me.isaiah.mods.permissions.Config;
import me.isaiah.mods.permissions.commands.PermsCommand;
import me.lucko.fabric.api.permissions.v0.PermissionCheckEvent;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CyberPermissionsMod
implements ModInitializer {
    public static Logger LOGGER = LogManager.getLogger((String)"CyberPermissions");
    public static File storage;
    public static HashMap<String, Config> groups;
    public static HashMap<String, Config> users;

    public static GameProfile findGameProfile(class_2168 cs, String name) {
        if (name.length() >= 32) {
            return (GameProfile)cs.method_9211().method_3793().method_14512(UUID.fromString(name)).get();
        }
        return (GameProfile)cs.method_9211().method_3793().method_14515(name).get();
    }

    public static Config getUser(GameProfile profile) {
        String uuid = profile.getId().toString();
        if (users.containsKey(uuid)) {
            return users.get(uuid);
        }
        try {
            Config conf = new Config(profile);
            users.put(conf.uuid, conf);
            return conf;
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load configuration for a user!");
            ex.printStackTrace();
            return null;
        }
    }

    public static Config getUser(class_3222 e) {
        String uuid = e.method_5667().toString();
        if (users.containsKey(uuid)) {
            return users.get(uuid);
        }
        try {
            Config conf = new Config(e);
            users.put(conf.uuid, conf);
            return conf;
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load configuration for a user!");
            ex.printStackTrace();
            return null;
        }
    }

    public void onInitialize() {
        LOGGER.info("Loading CyberPermissions...");
        storage = new File(FabricLoader.getInstance().getConfigDir().toFile(), "permissions");
        storage.mkdirs();
        File groupsDir = new File(storage, "groups");
        groupsDir.mkdir();
        for (File f : groupsDir.listFiles()) {
            try {
                Config conf = new Config(f);
                groups.put(conf.name, conf);
            }
            catch (IOException e) {
                LOGGER.error("Unable to load configuration for a group!");
                e.printStackTrace();
            }
        }
        if (!groups.containsKey("default")) {
            try {
                Config conf = new Config("default");
                groups.put(conf.name, conf);
            }
            catch (IOException e) {
                LOGGER.error("Unable to load configuration for a group!");
                e.printStackTrace();
            }
        }
        File usersDir = new File(storage, "users");
        usersDir.mkdir();
        for (File f : usersDir.listFiles()) {
            try {
                Config conf = new Config(f);
                users.put(conf.uuid, conf);
            }
            catch (IOException e) {
                LOGGER.error("Unable to load configuration for a user!");
                e.printStackTrace();
            }
        }
        PermsCommand cmd = new PermsCommand();
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, arg2) -> {
            cmd.register((CommandDispatcher<class_2168>)dispatcher, "perms");
            cmd.register((CommandDispatcher<class_2168>)dispatcher, "cyberperms");
        });
        PermissionCheckEvent.EVENT.register((source, permission) -> {
            if (source instanceof class_2168) {
                class_2168 ss = (class_2168)source;
                try {
                    class_3222 plr = ss.method_44023();
                    Permissible p = CyberPermissions.getPlayerPermissible(plr);
                    Permission perm = new Permission(permission, "LuckPerms API provided permission", PermissionDefaults.OPERATOR);
                    boolean hass = p.hasPermission(perm);
                    if (hass) {
                        return TriState.TRUE;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return TriState.DEFAULT;
        });
        LOGGER.info("CyberPermissions fully loaded...");
    }

    public LiteralArgumentBuilder<class_2168> literal(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    public static <T> RequiredArgumentBuilder<class_2168, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    static {
        groups = new HashMap();
        users = new HashMap();
    }
}

