/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials;

import com.alphine.mysticessentials.commands.CommandRegistrar;
import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.platform.ModInfoService;
import com.alphine.mysticessentials.storage.AfkPoolsStore;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.alphine.mysticessentials.storage.HomesStore;
import com.alphine.mysticessentials.storage.KitPlayerStore;
import com.alphine.mysticessentials.storage.KitStore;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.storage.PunishStore;
import com.alphine.mysticessentials.storage.SpawnStore;
import com.alphine.mysticessentials.storage.WarpsStore;
import com.alphine.mysticessentials.teleport.CooldownManager;
import com.alphine.mysticessentials.teleport.TpaManager;
import com.alphine.mysticessentials.teleport.WarmupManager;
import com.alphine.mysticessentials.util.AfkService;
import com.alphine.mysticessentials.util.GodService;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class MysticEssentialsCommon {
    private static final MysticEssentialsCommon I = new MysticEssentialsCommon();
    private ModInfoService modInfo;
    public static final String MOD_ID = "mysticessentials";
    public MEConfig cfg;
    public HomesStore homes;
    public WarpsStore warps;
    public SpawnStore spawn;
    public PlayerDataStore pdata;
    public AfkService afk;
    public AfkPoolsStore afkPools;
    public PunishStore punish;
    public AuditLogStore audit;
    public KitStore kits;
    public KitPlayerStore kitsPlayers;
    public final WarmupManager warmups = new WarmupManager();
    public final CooldownManager cooldowns = new CooldownManager();
    public final TpaManager tpas = new TpaManager();
    public final GodService god = new GodService();

    public static MysticEssentialsCommon get() {
        return I;
    }

    public void setModInfoService(ModInfoService svc) {
        this.modInfo = svc;
    }

    public ModInfoService getModInfoService() {
        return this.modInfo;
    }

    private MysticEssentialsCommon() {
    }

    public void serverStarting(MinecraftServer server) {
        Path cfgDir = server.getServerDirectory().resolve("config").resolve(MOD_ID).normalize();
        this.ensureCoreServices(cfgDir);
        this.cfg.afk.pools.clear();
        this.cfg.afk.pools.putAll(this.afkPools.viewAll());
        this.afk.reloadPools();
    }

    public void ensureCoreServices(Path cfgDir) {
        if (this.cfg == null) {
            this.cfg = MEConfig.load(cfgDir);
            if (MEConfig.INSTANCE == null) {
                MEConfig.INSTANCE = this.cfg;
            }
        }
        if (this.pdata == null) {
            this.pdata = new PlayerDataStore(cfgDir);
        }
        if (this.homes == null) {
            this.homes = new HomesStore(this.pdata);
        }
        if (this.warps == null) {
            this.warps = new WarpsStore(cfgDir);
        }
        if (this.spawn == null) {
            this.spawn = new SpawnStore(cfgDir);
        }
        if (this.afkPools == null) {
            this.afkPools = new AfkPoolsStore(cfgDir);
        }
        if (this.cfg.afk != null && this.cfg.afk.pools != null && this.cfg.afk.pools.isEmpty()) {
            this.cfg.afk.pools.putAll(this.afkPools.viewAll());
        }
        if (this.afk == null) {
            this.afk = new AfkService(this.cfg, this.pdata);
        }
        if (this.punish == null) {
            this.punish = new PunishStore(cfgDir);
        }
        if (this.audit == null) {
            this.audit = new AuditLogStore(cfgDir);
        }
        if (this.kits == null) {
            this.kits = new KitStore(cfgDir);
        }
        if (this.kitsPlayers == null) {
            this.kitsPlayers = new KitPlayerStore(this.pdata);
        }
    }

    public void registerCommands(CommandDispatcher<CommandSourceStack> d) {
        CommandRegistrar.registerAll(this, d);
    }

    public void serverStopping() {
        if (this.homes != null) {
            this.homes.save();
        }
        if (this.warps != null) {
            this.warps.save();
        }
        if (this.spawn != null) {
            this.spawn.save();
        }
        if (this.pdata != null) {
            this.pdata.save();
        }
        if (this.punish != null) {
            this.punish.save();
        }
        if (this.afkPools != null) {
            this.afkPools.save();
        }
    }

    public int reloadAll() {
        int n = 0;
        if (MEConfig.INSTANCE != null) {
            MEConfig.INSTANCE.reload();
            ++n;
        }
        try {
            this.cooldowns.updateFromConfig();
            ++n;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.afkPools != null && this.cfg != null) {
            this.cfg.afk.pools.clear();
            this.cfg.afk.pools.putAll(this.afkPools.viewAll());
            ++n;
        }
        if (this.afk != null) {
            this.afk.reloadPools();
            ++n;
        }
        return n;
    }

    public void serverTick1s(MinecraftServer server) {
        if (this.afk != null) {
            this.afk.tick(server);
        }
    }

    private boolean featuresEnabled() {
        return this.cfg != null && this.cfg.features != null && this.cfg.features.enableAfkSystem;
    }

    public void onPlayerMove(ServerPlayer p) {
        if (this.featuresEnabled() && this.afk != null) {
            this.afk.markActiveMovement(p);
        }
    }

    public void onPlayerInteract(ServerPlayer p) {
        if (this.featuresEnabled() && this.afk != null) {
            this.afk.markActiveInteraction(p);
        }
    }

    public void onPlayerChat(ServerPlayer p) {
        if (this.featuresEnabled() && this.afk != null) {
            this.afk.markActiveChat(p);
        }
    }

    public void onPlayerJoin(ServerPlayer p) {
        if (this.featuresEnabled() && this.afk != null) {
            this.afk.onJoin(p);
        }
    }

    public void onPlayerQuit(ServerPlayer p) {
        if (this.featuresEnabled() && this.afk != null) {
            this.afk.onQuit(p.getUUID());
        }
    }
}

