/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands;

import com.alphine.mysticessentials.MysticEssentialsCommon;
import com.alphine.mysticessentials.commands.CommandIndex;
import com.alphine.mysticessentials.commands.admin.ModlistCmd;
import com.alphine.mysticessentials.commands.admin.ReloadCmd;
import com.alphine.mysticessentials.commands.afk.AfkCmd;
import com.alphine.mysticessentials.commands.afk.AfkPoolSetupCmd;
import com.alphine.mysticessentials.commands.homes.DelHomeCmd;
import com.alphine.mysticessentials.commands.homes.HomeCmd;
import com.alphine.mysticessentials.commands.homes.HomesCmd;
import com.alphine.mysticessentials.commands.homes.SetHomeCmd;
import com.alphine.mysticessentials.commands.kits.CreateKitCmd;
import com.alphine.mysticessentials.commands.kits.DelKitCmd;
import com.alphine.mysticessentials.commands.kits.KitCmd;
import com.alphine.mysticessentials.commands.misc.AnvilCmd;
import com.alphine.mysticessentials.commands.misc.EnchantCmd;
import com.alphine.mysticessentials.commands.misc.FeedCmd;
import com.alphine.mysticessentials.commands.misc.FlyCmd;
import com.alphine.mysticessentials.commands.misc.GmCmd;
import com.alphine.mysticessentials.commands.misc.GodCmd;
import com.alphine.mysticessentials.commands.misc.HealCmd;
import com.alphine.mysticessentials.commands.misc.HelpCmd;
import com.alphine.mysticessentials.commands.misc.InvseeFullCmd;
import com.alphine.mysticessentials.commands.misc.JumpCmd;
import com.alphine.mysticessentials.commands.misc.NearCmd;
import com.alphine.mysticessentials.commands.misc.SpeedCmd;
import com.alphine.mysticessentials.commands.misc.TimeCmd;
import com.alphine.mysticessentials.commands.misc.WeatherCmd;
import com.alphine.mysticessentials.commands.misc.WorkbenchCmd;
import com.alphine.mysticessentials.commands.mod.BanCmds;
import com.alphine.mysticessentials.commands.mod.FreezeCmd;
import com.alphine.mysticessentials.commands.mod.HistoryCmd;
import com.alphine.mysticessentials.commands.mod.IpBanCmds;
import com.alphine.mysticessentials.commands.mod.JailCmds;
import com.alphine.mysticessentials.commands.mod.KickCmd;
import com.alphine.mysticessentials.commands.mod.MuteCmds;
import com.alphine.mysticessentials.commands.mod.WarnCmd;
import com.alphine.mysticessentials.commands.tp.BackCmds;
import com.alphine.mysticessentials.commands.tp.SpawnCmds;
import com.alphine.mysticessentials.commands.tp.TpDirectCmds;
import com.alphine.mysticessentials.commands.tp.TpaCmds;
import com.alphine.mysticessentials.commands.tp.WarpCmd;
import com.mojang.brigadier.CommandDispatcher;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;

public final class CommandRegistrar {
    private CommandRegistrar() {
    }

    private static boolean on(Supplier<Boolean> s) {
        try {
            Boolean b = s.get();
            return b == null || b != false;
        }
        catch (Throwable t) {
            return true;
        }
    }

    private static void idx(String ... roots) {
        for (String r : roots) {
            CommandIndex.indexRoot(r, "mysticessentials");
        }
    }

    public static void registerAll(MysticEssentialsCommon common, CommandDispatcher<CommandSourceStack> d) {
        new ReloadCmd(common).register(d);
        CommandRegistrar.idx("mereload");
        new HelpCmd().register(d);
        CommandRegistrar.idx("help");
        if (common.getModInfoService() != null) {
            new ModlistCmd(common.getModInfoService()).register(d);
            CommandRegistrar.idx("modlist");
        }
        if (CommandRegistrar.on(() -> common.cfg.features.enableAfkSystem)) {
            new AfkCmd(common.afk).register(d);
            CommandRegistrar.idx("afk");
            new AfkPoolSetupCmd(common.afk, common.cfg, common.afkPools).register(d);
            CommandRegistrar.idx("afkpool");
        }
        if (CommandRegistrar.on(() -> common.cfg.features.enableHomesWarpsTP)) {
            new SetHomeCmd(common.homes).register(d);
            CommandRegistrar.idx("sethome");
            new HomeCmd(common.homes, common.cooldowns, common.warmups, common.pdata).register(d);
            CommandRegistrar.idx("home");
            new DelHomeCmd(common.homes).register(d);
            CommandRegistrar.idx("delhome");
            new HomesCmd(common.homes).register(d);
            CommandRegistrar.idx("homes");
            new WarpCmd(common.warps, common.cooldowns, common.warmups, common.pdata).register(d);
            CommandRegistrar.idx("warp", "warps", "setwarp", "delwarp");
            new SpawnCmds(common.spawn, common.cooldowns, common.warmups, common.pdata).register(d);
            CommandRegistrar.idx("spawn", "setspawn");
            new TpDirectCmds(common.cooldowns, common.warmups, common.pdata).register(d);
            CommandRegistrar.idx("tp", "tppos", "tphere", "tpo");
            new TpaCmds(common.tpas, common.warmups, common.pdata).register(d);
            CommandRegistrar.idx("tpa", "tpahere", "tpaccept", "tpdeny", "tpcancel");
            new BackCmds(common.pdata).register(d);
            CommandRegistrar.idx("back");
        }
        if (CommandRegistrar.on(() -> common.cfg.features.enableMiscCommands)) {
            new GodCmd(common.god).register(d);
            CommandRegistrar.idx("god");
            new FlyCmd().register(d);
            CommandRegistrar.idx("fly");
            new HealCmd().register(d);
            CommandRegistrar.idx("heal");
            new FeedCmd().register(d);
            CommandRegistrar.idx("feed");
            new JumpCmd(common.pdata).register(d);
            CommandRegistrar.idx("jump");
            new NearCmd().register(d);
            CommandRegistrar.idx("near");
            new TimeCmd().register(d);
            CommandRegistrar.idx("time", "day", "night");
            new WeatherCmd().register(d);
            CommandRegistrar.idx("weather", "sun", "rain", "thunder");
            new SpeedCmd().register(d);
            CommandRegistrar.idx("speed", "walkspeed", "flyspeed");
            new WorkbenchCmd().register(d);
            CommandRegistrar.idx("workbench", "wb", "craft");
            new GmCmd().register(d);
            CommandRegistrar.idx("gm", "gmc", "gms", "gmsp", "gma");
            new InvseeFullCmd().register(d);
            CommandRegistrar.idx("invsee");
            new AnvilCmd().register(d);
            CommandRegistrar.idx("anvil");
            new EnchantCmd().register(d);
            CommandRegistrar.idx("enchant");
        }
        if (CommandRegistrar.on(() -> common.cfg.features.enableModerationSystem)) {
            new WarnCmd(common.punish, common.audit).register(d);
            CommandRegistrar.idx("warn");
            new KickCmd(common.audit).register(d);
            CommandRegistrar.idx("kick");
            new BanCmds(common.punish, common.audit).register(d);
            CommandRegistrar.idx("ban", "tempban", "unban");
            new IpBanCmds(common.punish, common.audit).register(d);
            CommandRegistrar.idx("ipban", "unipban");
            new MuteCmds(common.punish, common.audit).register(d);
            CommandRegistrar.idx("mute", "tempmute", "unmute");
            new FreezeCmd(common.punish, common.audit).register(d);
            CommandRegistrar.idx("freeze", "unfreeze");
            new JailCmds(common.punish, common.pdata, common.audit).register(d);
            CommandRegistrar.idx("jail", "unjail", "setjail", "deljail");
            new HistoryCmd(common.audit).register(d);
            CommandRegistrar.idx("history");
        }
        if (CommandRegistrar.on(() -> common.cfg.features.enableKits)) {
            new CreateKitCmd(common.kits).register(d);
            CommandRegistrar.idx("createkit");
            new DelKitCmd(common.kits).register(d);
            CommandRegistrar.idx("delkit");
            new KitCmd(common.kits, common.kitsPlayers).register(d);
            CommandRegistrar.idx("kit", "kits");
        }
    }
}

