/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.admin;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.platform.ModInfoService;
import com.alphine.mysticessentials.platform.PasteService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class ModlistCmd {
    private final ModInfoService mods;

    public ModlistCmd(ModInfoService mods) {
        this.mods = mods;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"modlist").requires(src -> src.hasPermission(2) || Perms.has(src, "messentials.modlist", 2))).executes(ctx -> this.show((CommandSourceStack)ctx.getSource(), "all", false))).then(((RequiredArgumentBuilder)Commands.argument((String)"filter", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.show((CommandSourceStack)ctx.getSource(), (String)ctx.getArgument("filter", String.class), false))).then(Commands.argument((String)"upload", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.show((CommandSourceStack)ctx.getSource(), (String)ctx.getArgument("filter", String.class), (Boolean)ctx.getArgument("upload", Boolean.class)))));
        root.then(Commands.literal((String)"upload").executes(ctx -> this.show((CommandSourceStack)ctx.getSource(), "all", true)));
        d.register(root);
    }

    private int show(CommandSourceStack src, String filter, boolean upload) {
        List<ModInfoService.ModInfo> all = this.mods.getAllMods().stream().sorted(Comparator.comparing(ModInfoService.ModInfo::id)).toList();
        String norm = filter.toLowerCase(Locale.ROOT);
        List<ModInfoService.ModInfo> filtered = all.stream().filter(m -> {
            if ("all".equals(norm)) {
                return true;
            }
            if ("enabled".equals(norm)) {
                return m.active();
            }
            if ("disabled".equals(norm)) {
                return !m.active();
            }
            return m.id().toLowerCase(Locale.ROOT).contains(norm) || m.name().toLowerCase(Locale.ROOT).contains(norm);
        }).toList();
        src.sendSystemMessage((Component)Component.literal((String)("\u2014 Mods (" + filtered.size() + "/" + all.size() + ") \u2014")).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
        int shown = 0;
        for (ModInfoService.ModInfo m2 : filtered) {
            if (shown++ >= 20) break;
            MutableComponent line = Component.literal((String)m2.id()).withStyle(m2.active() ? ChatFormatting.GREEN : ChatFormatting.RED).append((Component)Component.literal((String)"  ")).append((Component)Component.literal((String)m2.name()).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)("  v" + m2.version())).withStyle(ChatFormatting.DARK_GRAY));
            src.sendSystemMessage((Component)line);
        }
        if (filtered.size() > 20) {
            src.sendSystemMessage((Component)Component.literal((String)("\u2026and " + (filtered.size() - 20) + " more. Use ")).append((Component)Component.literal((String)("/modlist " + filter + " true")).withStyle(style -> style.withColor(ChatFormatting.AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/modlist " + filter + " true")).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Upload full list to mclo.gs"))))).append((Component)Component.literal((String)" to upload.")));
        }
        if (upload) {
            String text = filtered.stream().map(m -> String.format("%s | %s | %s | %s%s", m.id(), m.name(), m.version(), m.active() ? "ENABLED" : "DISABLED", m.sourceJar().map(p -> " | " + String.valueOf(p)).orElse(""))).collect(Collectors.joining("\n"));
            try {
                String url = PasteService.uploadToMclogs(text);
                src.sendSystemMessage((Component)Component.literal((String)"Uploaded to mclo.gs \u2192 ").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)url).withStyle(style -> style.withColor(ChatFormatting.AQUA).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, url)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Open in browser"))))));
            }
            catch (Exception e) {
                src.sendFailure((Component)Component.literal((String)("Upload failed: " + e.getMessage())).withStyle(ChatFormatting.RED));
                return 0;
            }
        }
        return 1;
    }
}

