/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.afk;

import com.alphine.mysticessentials.util.AfkService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public final class AfkCmd {
    private final AfkService afk;

    public AfkCmd(AfkService afk) {
        this.afk = Objects.requireNonNull(afk, "afk");
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"afk").executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            boolean nowAfk = this.afk.toggleAfk(p, null);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(nowAfk ? "You are now AFK." : "You are no longer AFK.")), false);
            return 1;
        })).then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String msg = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            boolean nowAfk = this.afk.toggleAfk(p, msg);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(nowAfk ? "You are now AFK." : "You are no longer AFK.")), false);
            return 1;
        })));
    }
}

