/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.afk;

import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AfkPoolsStore;
import com.alphine.mysticessentials.util.AfkService;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;

public final class AfkPoolSetupCmd {
    private final AfkService afkService;
    private final MEConfig config;
    private final AfkPoolsStore store;
    private final Map<UUID, Working> drafts = new ConcurrentHashMap<UUID, Working>();

    public AfkPoolSetupCmd(AfkService svc, MEConfig cfg, AfkPoolsStore store) {
        this.afkService = Objects.requireNonNull(svc);
        this.config = Objects.requireNonNull(cfg);
        this.store = Objects.requireNonNull(store);
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"afkpool").requires(src -> Perms.has(src, "messentials.afk.pool.set", 2))).then(Commands.literal((String)"setup").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.literal((String)"pos1").executes(ctx -> this.setPos((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), 1)))).then(Commands.literal((String)"pos2").executes(ctx -> this.setPos((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), 2)))).then(Commands.literal((String)"tp").executes(ctx -> this.setTp((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))).then(Commands.literal((String)"enable").executes(ctx -> this.setEnabled((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), true)))).then(Commands.literal((String)"disable").executes(ctx -> this.setEnabled((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), false)))).then(Commands.literal((String)"require-permission").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.flip((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "require-permission", BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))).then(Commands.literal((String)"allow-chat").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.flip((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "allow-chat", BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))).then(Commands.literal((String)"allow-exit").then(Commands.argument((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> this.flip((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), "allow-exit", BoolArgumentType.getBool((CommandContext)ctx, (String)"value")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"reward").then(Commands.literal((String)"add").then(Commands.argument((String)"trackId", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"everySeconds", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.rewardAdd((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"trackId"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"everySeconds"))))))).then(Commands.literal((String)"addcmd").then(Commands.argument((String)"trackId", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.rewardAddCmd((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"trackId"), StringArgumentType.getString((CommandContext)ctx, (String)"command"))))))).then(Commands.literal((String)"additem").then(Commands.argument((String)"trackId", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)Commands.argument((String)"material", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.rewardAddItem((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"trackId"), StringArgumentType.getString((CommandContext)ctx, (String)"material"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), "{}")))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.argument((String)"nbtJson", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.rewardAddItem((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"trackId"), StringArgumentType.getString((CommandContext)ctx, (String)"material"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), StringArgumentType.getString((CommandContext)ctx, (String)"nbtJson"))))))))).then(Commands.literal((String)"save").executes(ctx -> this.save((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"))))))));
    }

    private int setPos(CommandSourceStack src, String name, int which) {
        ServerPlayer p = src.getPlayer();
        if (p == null) {
            src.sendFailure((Component)Component.literal((String)"Players only."));
            return 0;
        }
        MEConfig.AfkPool base = this.store.get(name).orElse(this.config.afk.pools.get(name));
        Working w = this.drafts.computeIfAbsent(p.getUUID(), id -> new Working(name, base));
        if (!w.name.equalsIgnoreCase(name)) {
            w = new Working(name, base);
        }
        this.drafts.put(p.getUUID(), w);
        BlockPos bp = p.blockPosition();
        if (which == 1) {
            w.pos1Tmp = bp;
        } else {
            w.pos2Tmp = bp;
        }
        src.sendSuccess(() -> Component.literal((String)("Set " + (which == 1 ? "pos1" : "pos2") + " for pool '" + name + "' at " + bp.getX() + "," + bp.getY() + "," + bp.getZ())), false);
        return 1;
    }

    private int setTp(CommandSourceStack src, String name) {
        ServerPlayer p = src.getPlayer();
        if (p == null) {
            src.sendFailure((Component)Component.literal((String)"Players only."));
            return 0;
        }
        MEConfig.AfkPool base = this.store.get(name).orElse(this.config.afk.pools.get(name));
        Working w = this.drafts.computeIfAbsent(p.getUUID(), id -> new Working(name, base));
        if (!w.name.equalsIgnoreCase(name)) {
            w = new Working(name, base);
        }
        this.drafts.put(p.getUUID(), w);
        Vec3 pos = p.position();
        w.pool.teleport = new MEConfig.TeleportPoint(p.level().dimension().location().toString(), pos.x, pos.y, pos.z, p.getYRot(), p.getXRot());
        src.sendSuccess(() -> Component.literal((String)("Set teleport for pool '" + name + "'.")), false);
        return 1;
    }

    private int setEnabled(CommandSourceStack src, String name, boolean enabled) {
        Working w = this.ensureDraft(src, name);
        if (w == null) {
            return 0;
        }
        w.pool.enabled = enabled;
        src.sendSuccess(() -> Component.literal((String)((enabled ? "Enabled" : "Disabled") + " pool '" + name + "' (draft).")), false);
        return 1;
    }

    private int flip(CommandSourceStack src, String name, String field, boolean value) {
        Working w = this.ensureDraft(src, name);
        if (w == null) {
            return 0;
        }
        switch (field) {
            case "require-permission": {
                w.pool.requirePermission = value;
                break;
            }
            case "allow-chat": {
                w.pool.allowChatInside = value;
                break;
            }
            case "allow-exit": {
                w.pool.allowEnterExitFreely = value;
            }
        }
        src.sendSuccess(() -> Component.literal((String)("Set " + field + "=" + value + " for pool '" + name + "' (draft).")), false);
        return 1;
    }

    private int rewardAdd(CommandSourceStack src, String name, String trackId, int everySeconds) {
        Working w = this.ensureDraft(src, name);
        if (w == null) {
            return 0;
        }
        MEConfig.AfkReward tr = this.findOrCreateTrack(w.pool, trackId);
        tr.id = trackId;
        tr.everySeconds = everySeconds;
        src.sendSuccess(() -> Component.literal((String)("Added/updated reward track '" + trackId + "' (every " + everySeconds + "s) for pool '" + name + "' (draft).")), false);
        return 1;
    }

    private int rewardAddCmd(CommandSourceStack src, String name, String trackId, String cmd) {
        Working w = this.ensureDraft(src, name);
        if (w == null) {
            return 0;
        }
        MEConfig.AfkReward tr = this.findOrCreateTrack(w.pool, trackId);
        if (tr.commands == null) {
            tr.commands = new ArrayList<String>();
        }
        tr.commands.add(cmd);
        src.sendSuccess(() -> Component.literal((String)("Added command to track '" + trackId + "': " + cmd)), false);
        return 1;
    }

    private int rewardAddItem(CommandSourceStack src, String name, String trackId, String material, int amount, String nbtJson) {
        Working w = this.ensureDraft(src, name);
        if (w == null) {
            return 0;
        }
        MEConfig.AfkReward tr = this.findOrCreateTrack(w.pool, trackId);
        if (tr.items == null) {
            tr.items = new ArrayList<MEConfig.ItemSpec>();
        }
        MEConfig.ItemSpec it = new MEConfig.ItemSpec();
        it.type = material;
        it.amount = amount;
        it.nbt = nbtJson == null || nbtJson.isBlank() ? "{}" : nbtJson;
        tr.items.add(it);
        src.sendSuccess(() -> Component.literal((String)("Added item to track '" + trackId + "': " + material + " x" + amount)), false);
        return 1;
    }

    private int save(CommandSourceStack src, String name) {
        ServerPlayer p = src.getPlayer();
        if (p == null) {
            src.sendFailure((Component)Component.literal((String)"Players only."));
            return 0;
        }
        Working w = this.drafts.get(p.getUUID());
        if (w == null || !w.name.equalsIgnoreCase(name)) {
            src.sendFailure((Component)Component.literal((String)("No draft found for '" + name + "'. Start with pos1/pos2/tp.")));
            return 0;
        }
        if (w.pos1Tmp != null && w.pos2Tmp != null) {
            int minX = Math.min(w.pos1Tmp.getX(), w.pos2Tmp.getX());
            int minY = Math.min(w.pos1Tmp.getY(), w.pos2Tmp.getY());
            int minZ = Math.min(w.pos1Tmp.getZ(), w.pos2Tmp.getZ());
            int maxX = Math.max(w.pos1Tmp.getX(), w.pos2Tmp.getX());
            int maxY = Math.max(w.pos1Tmp.getY(), w.pos2Tmp.getY());
            int maxZ = Math.max(w.pos1Tmp.getZ(), w.pos2Tmp.getZ());
            if (w.pool.region == null) {
                w.pool.region = new MEConfig.PoolBox();
            }
            w.pool.region.world = p.level().dimension().location().toString();
            w.pool.region.min = new MEConfig.Vec3i(minX, minY, minZ);
            w.pool.region.max = new MEConfig.Vec3i(maxX, maxY, maxZ);
        }
        this.store.put(name, w.pool);
        this.config.afk.pools.clear();
        this.config.afk.pools.putAll(this.store.viewAll());
        this.afkService.reloadPools();
        this.drafts.remove(p.getUUID());
        src.sendSuccess(() -> Component.literal((String)("Saved AFK pool '" + name + "' to afk_pools.json and reloaded AFK service.")), true);
        return 1;
    }

    private Working ensureDraft(CommandSourceStack src, String name) {
        ServerPlayer p = src.getPlayer();
        if (p == null) {
            src.sendFailure((Component)Component.literal((String)"Players only."));
            return null;
        }
        MEConfig.AfkPool base = this.store.get(name).orElse(this.config.afk.pools.get(name));
        Working w = this.drafts.computeIfAbsent(p.getUUID(), id -> new Working(name, base));
        if (!w.name.equalsIgnoreCase(name)) {
            w = new Working(name, base);
            this.drafts.put(p.getUUID(), w);
        }
        return w;
    }

    private MEConfig.AfkReward findOrCreateTrack(MEConfig.AfkPool pool, String trackId) {
        if (pool.rewards == null) {
            pool.rewards = new ArrayList<MEConfig.AfkReward>();
        }
        for (MEConfig.AfkReward r : pool.rewards) {
            if (!r.id.equalsIgnoreCase(trackId)) continue;
            return r;
        }
        MEConfig.AfkReward r = new MEConfig.AfkReward();
        r.id = trackId;
        pool.rewards.add(r);
        return r;
    }

    private static final class Working {
        final String name;
        final MEConfig.AfkPool pool;
        BlockPos pos1Tmp;
        BlockPos pos2Tmp;

        Working(String name, MEConfig.AfkPool base) {
            this.name = name;
            MEConfig.AfkPool afkPool = this.pool = base != null ? base : new MEConfig.AfkPool();
            if (this.pool.region == null) {
                this.pool.region = new MEConfig.PoolBox();
            }
            if (this.pool.teleport == null) {
                this.pool.teleport = new MEConfig.TeleportPoint("minecraft:overworld", 0.5, 64.0, 0.5, 0.0f, 0.0f);
            }
        }
    }
}

