/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.homes;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.HomesStore;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class DelHomeCmd {
    private final HomesStore store;

    public DelHomeCmd(HomesStore store) {
        this.store = store;
    }

    private SuggestionProvider<CommandSourceStack> homeSuggest() {
        return (ctx, b) -> {
            try {
                ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                for (String n : this.store.names(p.getUUID())) {
                    b.suggest(n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return b.buildFuture();
        };
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delhome").requires(src -> Perms.has(src, "messentials.home.del", 0))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this.homeSuggest()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            boolean ok = this.store.delete(p.getUUID(), name);
            p.displayClientMessage((Component)Component.literal((String)(ok ? "\u00a7aDeleted home \u00a7e" + name : "\u00a7cNo home named \u00a7e" + name)), false);
            return ok ? 1 : 0;
        })));
    }
}

