/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.homes;

import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.Bypass;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.HomesStore;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.teleport.CooldownManager;
import com.alphine.mysticessentials.teleport.WarmupManager;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class HomeCmd {
    private final HomesStore store;
    private final CooldownManager cooldowns;
    private final WarmupManager warmups;
    private final PlayerDataStore pdata;

    public HomeCmd(HomesStore s, CooldownManager c, WarmupManager w, PlayerDataStore pdata) {
        this.store = s;
        this.cooldowns = c;
        this.warmups = w;
        this.pdata = pdata;
    }

    private SuggestionProvider<CommandSourceStack> homeSuggest() {
        return (ctx, b) -> {
            try {
                ServerPlayer target = ctx.getNodes().size() >= 2 ? (ctx.getNodes().stream().anyMatch(n -> "player".equals(n.getNode().getName())) ? EntityArgument.getPlayer((CommandContext)ctx, (String)"player") : ((CommandSourceStack)ctx.getSource()).getPlayerOrException()) : ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
                for (String n2 : this.store.names(target.getUUID())) {
                    b.suggest(n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return b.buildFuture();
        };
    }

    private static boolean featureOn() {
        MEConfig c = MEConfig.INSTANCE;
        return c == null || c.features == null || c.features.enableHomesWarpsTP;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"home").requires(src -> Perms.has(src, "messentials.home.use", 0))).then(((RequiredArgumentBuilder)Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(this.homeSuggest()).executes(ctx -> this.tpToHome((CommandContext<CommandSourceStack>)ctx, ((CommandSourceStack)ctx.getSource()).getPlayerOrException(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).requires(src -> Perms.has(src, "messentials.home.others", 2))).suggests(this.homeSuggest()).executes(ctx -> {
            ServerPlayer executor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ServerPlayer target = EntityArgument.getPlayer((CommandContext)ctx, (String)"player");
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return this.tpToHome((CommandContext<CommandSourceStack>)ctx, target, name);
        }))));
    }

    private int tpToHome(CommandContext<CommandSourceStack> ctx, ServerPlayer target, String name) {
        ServerPlayer actor;
        if (!HomeCmd.featureOn()) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
            return 0;
        }
        try {
            actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        }
        catch (Exception e) {
            return 0;
        }
        Optional<HomesStore.Home> opt = this.store.get(target.getUUID(), name);
        if (opt.isEmpty()) {
            actor.displayClientMessage((Component)Component.literal((String)("\u00a7cNo home named \u00a7e" + name + " \u00a7cfor \u00a7e" + target.getGameProfile().getName())), false);
            return 0;
        }
        HomesStore.Home h = opt.get();
        long now = System.currentTimeMillis();
        if (!Bypass.cooldown((CommandSourceStack)ctx.getSource()) && this.cooldowns.getDefaultSeconds("home") > 0 && !this.cooldowns.checkAndStampDefault(actor.getUUID(), "home", now)) {
            long rem = this.cooldowns.remaining(actor.getUUID(), "home", now);
            actor.displayClientMessage((Component)Component.literal((String)("\u00a7cCooldown: \u00a7e" + rem + "s")), false);
            return 0;
        }
        int warmSec = MEConfig.INSTANCE != null ? MEConfig.INSTANCE.getWarmup("home") : 0;
        Runnable tp = () -> {
            ResourceLocation id = ResourceLocation.tryParse((String)h.dim);
            if (id == null) {
                actor.displayClientMessage((Component)Component.literal((String)("\u00a7cBad dimension id: " + h.dim)), false);
                return;
            }
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
            ServerLevel level = actor.getServer().getLevel(key);
            if (level == null) {
                actor.displayClientMessage((Component)Component.literal((String)("\u00a7cWorld missing: " + h.dim)), false);
                return;
            }
            Teleports.pushBackAndTeleport(actor, level, h.x, h.y, h.z, h.yaw, h.pitch, this.pdata);
        };
        if (Bypass.warmup((CommandSourceStack)ctx.getSource())) {
            tp.run();
        } else {
            this.warmups.startOrBypass(((CommandSourceStack)ctx.getSource()).getServer(), actor, warmSec, tp);
        }
        return 1;
    }
}

