/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.homes;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.HomesStore;
import com.alphine.mysticessentials.util.HomeLimitResolver;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class HomesCmd {
    private final HomesStore store;

    public HomesCmd(HomesStore store) {
        this.store = store;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"homes").requires(src -> Perms.has(src, "messentials.home.list", 0))).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            List names = this.store.names(p.getUUID()).stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList());
            int limit = HomeLimitResolver.resolve(p);
            p.displayClientMessage((Component)Component.literal((String)(names.isEmpty() ? "\u00a77You have no homes. \u00a78(\u00a77limit: " + limit + "\u00a78)" : "\u00a7aHomes (" + names.size() + "/" + limit + "): \u00a7e" + String.join((CharSequence)"\u00a77, \u00a7e", names))), false);
            return 1;
        }));
    }
}

