/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.homes;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.HomesStore;
import com.alphine.mysticessentials.util.HomeLimitResolver;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class SetHomeCmd {
    private final HomesStore store;

    public SetHomeCmd(HomesStore store) {
        this.store = store;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"sethome").requires(src -> Perms.has(src, "messentials.home.set", 0))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            int limit = HomeLimitResolver.resolve(p);
            int existing = this.store.all(p.getUUID()).size();
            boolean replacing = this.store.get(p.getUUID(), name).isPresent();
            if (!replacing && existing >= limit) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cHome limit reached (\u00a7e" + limit + "\u00a7c).")), false);
                return 0;
            }
            BlockPos pos = p.blockPosition();
            HomesStore.Home h = new HomesStore.Home();
            h.name = name;
            h.dim = p.serverLevel().dimension().location().toString();
            h.x = (double)pos.getX() + 0.5;
            h.y = pos.getY();
            h.z = (double)pos.getZ() + 0.5;
            h.yaw = p.getYRot();
            h.pitch = p.getXRot();
            this.store.set(p.getUUID(), h);
            p.displayClientMessage((Component)Component.literal((String)("\u00a7aHome \u00a7e" + name + " \u00a7aset.")), false);
            return 1;
        })));
    }
}

