/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.kits;

import com.alphine.mysticessentials.perm.PermNodes;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.KitStore;
import com.alphine.mysticessentials.util.DurationUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CreateKitCmd {
    private final KitStore kits;

    public CreateKitCmd(KitStore kits) {
        this.kits = kits;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"createkit").requires(src -> Perms.has(src, "messentials.kits.create", 2))).then(Commands.argument((String)"kit", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"time", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ItemStack st;
            int i;
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            RegistryAccess.Frozen provider = p.server.registryAccess();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"kit");
            String timeArg = StringArgumentType.getString((CommandContext)ctx, (String)"time").toLowerCase();
            long cooldown = 0L;
            boolean oneTime = false;
            if (timeArg.equals("-1")) {
                oneTime = true;
            } else if (timeArg.equals("0") || timeArg.equals("none") || timeArg.equals("off")) {
                cooldown = 0L;
            } else {
                cooldown = DurationUtil.parseToMillis(timeArg);
                if (cooldown < 0L) {
                    cooldown = 0L;
                }
            }
            KitStore.Kit kit = new KitStore.Kit();
            kit.name = name;
            kit.cooldownMillis = cooldown;
            kit.oneTime = oneTime;
            Inventory inv = p.getInventory();
            for (i = 0; i < 36; ++i) {
                st = inv.getItem(i);
                if (st.isEmpty()) continue;
                kit.itemsB64.add(KitStore.stackToB64(st, (HolderLookup.Provider)provider));
            }
            for (i = 0; i < 4; ++i) {
                st = (ItemStack)inv.armor.get(i);
                if (st.isEmpty()) continue;
                kit.itemsB64.add(KitStore.stackToB64(st, (HolderLookup.Provider)provider));
            }
            if (!((ItemStack)inv.offhand.get(0)).isEmpty()) {
                kit.itemsB64.add(KitStore.stackToB64((ItemStack)inv.offhand.getFirst(), (HolderLookup.Provider)provider));
            }
            this.kits.put(kit);
            p.displayClientMessage((Component)Component.literal((String)("\u00a7aKit \u00a7e" + name + " \u00a7asaved. " + (String)(oneTime ? "\u00a77(one-time)" : (cooldown > 0L ? "\u00a77cooldown \u00a7e" + DurationUtil.fmtRemaining(cooldown) : "\u00a77no cooldown")))), false);
            p.displayClientMessage((Component)Component.literal((String)("\u00a77Permission to use: \u00a7e" + PermNodes.kitNode(name))), false);
            return 1;
        }))));
    }
}

