/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.kits;

import com.alphine.mysticessentials.perm.PermNodes;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.KitPlayerStore;
import com.alphine.mysticessentials.storage.KitStore;
import com.alphine.mysticessentials.util.DurationUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class KitCmd {
    private final KitStore kits;
    private final KitPlayerStore pdata;

    public KitCmd(KitStore kits, KitPlayerStore pdata) {
        this.kits = kits;
        this.pdata = pdata;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kit").requires(src -> Perms.has(src, "messentials.kits", 0))).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            List available = this.kits.names().stream().filter(n -> Perms.has(p, PermNodes.kitNode(n), 0) || Perms.has(p, "messentials.admin", 2) || Perms.has(p, "messentials.*", 2)).sorted().collect(Collectors.toList());
            if (available.isEmpty()) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a77You have no kits."), false);
            } else {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7aKits: \u00a7e" + String.join((CharSequence)"\u00a77, \u00a7e", available))), false);
            }
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"kit", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String kitName = StringArgumentType.getString((CommandContext)ctx, (String)"kit");
            return this.giveKit((CommandSourceStack)ctx.getSource(), kitName, p, p, false);
        })).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).requires(src -> Perms.has(src, "messentials.kits.others", 2))).executes(ctx -> {
            ServerPlayer issuer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String kitName = StringArgumentType.getString((CommandContext)ctx, (String)"kit");
            String targetName = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer target = issuer.getServer().getPlayerList().getPlayerByName(targetName);
            if (target == null) {
                issuer.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            return this.giveKit((CommandSourceStack)ctx.getSource(), kitName, target, issuer, true);
        }))));
    }

    private int giveKit(CommandSourceStack src, String kitName, ServerPlayer target, ServerPlayer issuer, boolean isOthers) {
        long last;
        long rem;
        boolean bypassOthers;
        boolean issuerAdmin;
        Optional<KitStore.Kit> opt = this.kits.get(kitName);
        if (opt.isEmpty()) {
            issuer.displayClientMessage((Component)Component.literal((String)("\u00a7cNo kit named \u00a7e" + kitName)), false);
            return 0;
        }
        KitStore.Kit kit = opt.get();
        String node = PermNodes.kitNode(kit.name);
        RegistryAccess.Frozen provider = target.server.registryAccess();
        boolean bl = issuerAdmin = Perms.has(issuer, "messentials.admin", 2) || Perms.has(issuer, "messentials.*", 2);
        if (!issuerAdmin && !Perms.has(target, node, 0)) {
            issuer.displayClientMessage((Component)Component.literal((String)("\u00a7cTarget lacks permission: \u00a7e" + node)), false);
            return 0;
        }
        long now = System.currentTimeMillis();
        boolean bypassSelf = !isOthers && (Perms.has(issuer, "messentials.kits.bypass.cooldown", 2) || issuerAdmin);
        boolean bl2 = bypassOthers = isOthers && (Perms.has(issuer, "messentials.kits.bypass.cooldown.others", 2) || issuerAdmin);
        if (kit.oneTime && !bypassSelf && !bypassOthers && this.pdata.hasUsedOnce(target.getUUID(), kit.name)) {
            if (issuer == target) {
                issuer.displayClientMessage((Component)Component.literal((String)"\u00a7cYou have already claimed this one-time kit."), false);
            } else {
                issuer.displayClientMessage((Component)Component.literal((String)"\u00a7cThat player has already claimed this one-time kit."), false);
            }
            return 0;
        }
        if (kit.cooldownMillis > 0L && !bypassSelf && !bypassOthers && (rem = (last = this.pdata.getLast(target.getUUID(), kit.name)) + kit.cooldownMillis - now) > 0L) {
            String msg = "\u00a7cCooldown remaining: \u00a7e" + DurationUtil.fmtRemaining(rem);
            if (issuer == target) {
                issuer.displayClientMessage((Component)Component.literal((String)msg), false);
            } else {
                issuer.displayClientMessage((Component)Component.literal((String)("\u00a7cTarget cooldown. " + msg)), false);
            }
            return 0;
        }
        int given = 0;
        for (String b64 : kit.itemsB64) {
            ItemStack st = KitStore.b64ToStack(b64, (HolderLookup.Provider)provider);
            if (st.isEmpty()) continue;
            if (!target.addItem(st.copy())) {
                target.drop(st.copy(), false, true);
            }
            ++given;
        }
        if (!bypassSelf && !bypassOthers) {
            this.pdata.setLast(target.getUUID(), kit.name, now);
            if (kit.oneTime) {
                this.pdata.markUsedOnce(target.getUUID(), kit.name);
            }
        }
        if (issuer == target) {
            issuer.displayClientMessage((Component)Component.literal((String)("\u00a7aReceived kit \u00a7e" + kit.name + " \u00a77(" + given + " items)")), false);
        } else {
            issuer.displayClientMessage((Component)Component.literal((String)("\u00a7aGave kit \u00a7e" + kit.name + " \u00a77to \u00a7e" + target.getName().getString() + " \u00a77(" + given + " items)")), false);
            target.displayClientMessage((Component)Component.literal((String)("\u00a7aYou received kit \u00a7e" + kit.name + " \u00a77from \u00a7e" + issuer.getName().getString())), false);
        }
        return 1;
    }
}

