/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.misc;

import com.alphine.mysticessentials.perm.Perms;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class EnchantCmd {
    private static final SuggestionProvider<CommandSourceStack> ENCH_SUGGEST = (ctx, b) -> {
        ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack stack = p.getMainHandItem();
        Registry reg = ((CommandSourceStack)ctx.getSource()).registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        for (Holder.Reference h : reg.holders().toList()) {
            boolean ok = stack.is(Items.ENCHANTED_BOOK) || ((Enchantment)h.value()).canEnchant(stack);
            if (!ok) continue;
            b.suggest(h.key().location().toString());
        }
        return b.buildFuture();
    };

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"enchant").requires(src -> Perms.has(src, "messentials.enchant.use", 2))).then(Commands.argument((String)"enchantment", (ArgumentType)ResourceLocationArgument.id()).suggests(ENCH_SUGGEST).then(Commands.argument((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            ItemStack stack = p.getMainHandItem();
            if (stack.isEmpty()) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cHold an item (or an enchanted book)."), false);
                return 0;
            }
            ResourceLocation rl = ResourceLocationArgument.getId((CommandContext)ctx, (String)"enchantment");
            Registry reg = p.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
            Optional optHolder = reg.getHolder(ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)rl));
            if (optHolder.isEmpty()) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cUnknown enchantment: \u00a7e" + String.valueOf(rl))), false);
                return 0;
            }
            Holder.Reference ref = (Holder.Reference)optHolder.get();
            int level = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"level");
            boolean book = stack.is(Items.ENCHANTED_BOOK);
            if (!book && !((Enchantment)ref.value()).canEnchant(stack)) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cThat enchantment can\u2019t be applied to this item."), false);
                return 0;
            }
            DataComponentType compType = book ? DataComponents.STORED_ENCHANTMENTS : DataComponents.ENCHANTMENTS;
            ItemEnchantments current = (ItemEnchantments)stack.getOrDefault(compType, (Object)ItemEnchantments.EMPTY);
            ItemEnchantments.Mutable mut = new ItemEnchantments.Mutable(current);
            if (level <= 0) {
                mut.set((Holder)ref, 0);
                ItemEnchantments after = mut.toImmutable();
                if (after.isEmpty()) {
                    stack.remove(compType);
                } else {
                    stack.set(compType, (Object)after);
                }
                p.displayClientMessage((Component)Component.literal((String)("\u00a77Removed \u00a7e" + String.valueOf(rl) + " \u00a77from item.")), false);
            } else {
                mut.set((Holder)ref, level);
                stack.set(compType, (Object)mut.toImmutable());
                p.displayClientMessage((Component)Component.literal((String)("\u00a7aApplied \u00a7e" + String.valueOf(rl) + " \u00a77lvl \u00a7e" + level + " \u00a7ato item.")), false);
            }
            return 1;
        }))));
    }
}

