/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.misc;

import com.alphine.mysticessentials.commands.CommandIndex;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;

public class HelpCmd {
    private static final int PAGE_SIZE = 8;

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"help").executes(ctx -> this.show((CommandSourceStack)ctx.getSource(), Optional.empty(), Optional.empty(), 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.show((CommandSourceStack)ctx.getSource(), Optional.empty(), Optional.empty(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))).then(Commands.argument((String)"filter", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> this.show((CommandSourceStack)ctx.getSource(), Optional.of(StringArgumentType.getString((CommandContext)ctx, (String)"filter")), Optional.empty(), 1)))).then(Commands.literal((String)"mod").then(Commands.argument((String)"modid", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.show((CommandSourceStack)ctx.getSource(), Optional.empty(), Optional.of(StringArgumentType.getString((CommandContext)ctx, (String)"modid")), 1)))));
    }

    private int show(CommandSourceStack src, Optional<String> filter, Optional<String> modFilter, int page) {
        RootCommandNode root = src.getServer().getCommands().getDispatcher().getRoot();
        List visible = root.getChildren().stream().filter(n -> n.canUse((Object)src)).sorted(Comparator.comparing(CommandNode::getName)).collect(Collectors.toList());
        String f = filter.map(String::toLowerCase).orElse(null);
        String mf = modFilter.map(String::toLowerCase).orElse(null);
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (CommandNode n2 : visible) {
            String name = n2.getName();
            String mod = CommandIndex.modOf(name);
            if (f != null && !name.toLowerCase().contains(f) || mf != null && !mod.equals(mf)) continue;
            Map usage = src.getServer().getCommands().getDispatcher().getSmartUsage(n2, (Object)src);
            if (usage.isEmpty()) {
                entries.add(new Entry(name, mod, "/" + name));
                continue;
            }
            for (String u : usage.values()) {
                entries.add(new Entry(name, mod, "/" + name + " " + u));
            }
        }
        int pages = Math.max(1, (int)Math.ceil((double)entries.size() / 8.0));
        page = Math.max(1, Math.min(page, pages));
        int from = (page - 1) * 8;
        int to = Math.min(entries.size(), from + 8);
        src.sendSystemMessage(this.titleComponent(entries.size(), page, pages, filter, modFilter));
        for (int i = from; i < to; ++i) {
            Entry e = (Entry)entries.get(i);
            MutableComponent line = Component.literal((String)e.usage()).withStyle(ChatFormatting.AQUA).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, e.usage())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)("Click to copy/run\nMod: " + e.modId())))));
            src.sendSystemMessage((Component)Component.literal((String)("[/" + e.root() + "] ")).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)("[" + e.modId() + "] ")).withStyle(ChatFormatting.DARK_GRAY)).append((Component)line));
        }
        if (pages > 1) {
            MutableComponent prev = page > 1 ? this.pagerButton("\u2190 Prev", page - 1, filter, modFilter) : Component.literal((String)"\u2190 Prev").withStyle(ChatFormatting.DARK_GRAY);
            MutableComponent next = page < pages ? this.pagerButton("Next \u2192", page + 1, filter, modFilter) : Component.literal((String)"Next \u2192").withStyle(ChatFormatting.DARK_GRAY);
            src.sendSystemMessage((Component)prev.copy().append((Component)Component.literal((String)"  ")).append((Component)next));
        }
        return 1;
    }

    private Component titleComponent(int total, int page, int pages, Optional<String> filter, Optional<String> mod) {
        String base = "\u2014 Help (" + total + " cmds";
        if (filter.isPresent()) {
            base = base + ", filter=\"" + filter.get() + "\"";
        }
        if (mod.isPresent()) {
            base = base + ", mod=" + mod.get();
        }
        base = base + ") \u2014 Page " + page + "/" + pages;
        return Component.literal((String)base).withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
    }

    private MutableComponent pagerButton(String label, int page, Optional<String> filter, Optional<String> mod) {
        String cmd;
        if (mod.isPresent()) {
            cmd = "/help mod " + mod.get() + " " + page;
            if (filter.isPresent()) {
                cmd = (String)cmd + " " + filter.get();
            }
        } else {
            cmd = "/help " + page;
            if (filter.isPresent()) {
                cmd = cmd + " " + filter.get();
            }
        }
        String hover = "Go to page " + page;
        String finalCmd = cmd;
        return Component.literal((String)label).withStyle(style -> style.withColor(ChatFormatting.YELLOW).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, finalCmd)).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)hover))));
    }

    private record Entry(String root, String modId, String usage) {
    }
}

