/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.misc;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class JumpCmd {
    private final PlayerDataStore pdata;

    public JumpCmd(PlayerDataStore pdata) {
        this.pdata = pdata;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"jump").requires(src -> Perms.has(src, "messentials.jump.use", 2))).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            double range = 100.0;
            Vec3 eye = p.getEyePosition();
            Vec3 look = p.getLookAngle();
            Vec3 end = eye.add(look.scale(range));
            BlockHitResult hit = p.level().clip(new ClipContext(eye, end, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)p));
            if (hit == null || hit.getType() != HitResult.Type.BLOCK) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cNo block in sight within " + (int)range + " blocks.")), false);
                return 0;
            }
            Vec3 pos = hit.getLocation();
            Teleports.pushBackAndTeleport(p, p.serverLevel(), pos.x, pos.y + 1.0, pos.z, p.getYRot(), p.getXRot(), this.pdata);
            p.displayClientMessage((Component)Component.literal((String)"\u00a7aTeleported ahead."), false);
            return 1;
        }));
    }
}

