/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.mod;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.alphine.mysticessentials.storage.PunishStore;
import com.alphine.mysticessentials.util.DurationUtil;
import com.alphine.mysticessentials.util.ModerationPerms;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import java.util.Date;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class BanCmds {
    private final PunishStore store;
    private final AuditLogStore audit;

    public BanCmds(PunishStore store, AuditLogStore audit) {
        this.store = store;
        this.audit = audit;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ban").requires(src -> Perms.has(src, "messentials.ban.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String reason = StringArgumentType.getString((CommandContext)ctx, (String)"reason");
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (ModerationPerms.exempt(target, "ban")) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cTarget is exempt."), false);
                return 0;
            }
            PunishStore.Ban b = new PunishStore.Ban();
            b.target = target.getUUID();
            b.actor = actor.getUUID();
            b.reason = reason;
            b.at = System.currentTimeMillis();
            b.until = null;
            this.store.banUuid(b);
            target.connection.disconnect((Component)Component.literal((String)("\u00a7cBanned: \u00a7f" + reason)));
            actor.displayClientMessage((Component)Component.literal((String)("\u00a7aBanned \u00a7e" + name)), false);
            this.audit.log(AuditLogStore.make("BAN", actor.getUUID(), target.getUUID(), target.getName().getString(), reason, null, null, null));
            return 1;
        }))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tempban").requires(src -> Perms.has(src, "messentials.tempban.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"duration", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String durStr = StringArgumentType.getString((CommandContext)ctx, (String)"duration");
            String reason = StringArgumentType.getString((CommandContext)ctx, (String)"reason");
            long ms = DurationUtil.parseToMillis(durStr);
            if (ms <= 0L) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cInvalid duration."), false);
                return 0;
            }
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (ModerationPerms.exempt(target, "tempban")) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cTarget is exempt."), false);
                return 0;
            }
            PunishStore.Ban b = new PunishStore.Ban();
            b.target = target.getUUID();
            b.actor = actor.getUUID();
            b.reason = reason;
            b.at = System.currentTimeMillis();
            b.until = b.at + ms;
            this.store.banUuid(b);
            target.connection.disconnect((Component)Component.literal((String)("\u00a7cTemp-banned until \u00a7e" + String.valueOf(new Date(b.until)) + "\u00a7c: \u00a7f" + reason)));
            actor.displayClientMessage((Component)Component.literal((String)("\u00a7aTemp-banned \u00a7e" + name + " \u00a77for \u00a7e" + durStr)), false);
            this.audit.log(AuditLogStore.make("TEMPBAN", actor.getUUID(), target.getUUID(), target.getName().getString(), reason, b.until, null, null));
            return 1;
        })))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unban").requires(src -> Perms.has(src, "messentials.unban.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            GameProfile profile = src.getServer().getProfileCache().get(name).orElse(null);
            if (profile == null) {
                src.sendFailure((Component)Component.literal((String)"\u00a7cUnknown profile."));
                return 0;
            }
            this.store.unbanUuid(profile.getId());
            src.sendSuccess(() -> Component.literal((String)("\u00a7aUnbanned \u00a7e" + name)), false);
            this.audit.log(AuditLogStore.make("UNBAN", src.getPlayerOrException().getUUID(), profile.getId(), profile.getName(), null, null, null, null));
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"banlist").requires(src -> Perms.has(src, "messentials.banlist.use", 2))).executes(ctx -> {
            Collection<PunishStore.Ban> list = this.store.allBans();
            if (list.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a77No active bans."), false);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"\u00a7aActive bans:"), false);
            for (PunishStore.Ban b : list) {
                String who = b.target != null ? b.target.toString() : b.ip;
                String until = b.until == null ? "permanent" : new Date(b.until).toString();
                ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)("\u00a77- \u00a7e" + who + " \u00a77until \u00a7e" + until + " \u00a77reason \u00a7f" + b.reason)), false);
            }
            return 1;
        }));
    }
}

