/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.mod;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.alphine.mysticessentials.storage.PunishStore;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class FreezeCmd {
    private final PunishStore store;
    private final AuditLogStore audit;

    public FreezeCmd(PunishStore store, AuditLogStore audit) {
        this.store = store;
        this.audit = audit;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"freeze").requires(src -> Perms.has(src, "messentials.freeze.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            boolean on = this.store.toggleFreeze(target.getUUID());
            target.displayClientMessage((Component)Component.literal((String)(on ? "\u00a7cYou have been frozen." : "\u00a7aYou are unfrozen.")), false);
            actor.displayClientMessage((Component)Component.literal((String)((on ? "\u00a7aFroze " : "\u00a7aUnfroze ") + target.getName().getString())), false);
            this.audit.log(AuditLogStore.make(on ? "FREEZE" : "UNFREEZE", actor.getUUID(), target.getUUID(), target.getName().getString(), null, null, null, null));
            return 1;
        })));
    }
}

