/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.mod;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class HistoryCmd {
    private static final int PAGE_SIZE = 10;
    private final AuditLogStore audit;

    public HistoryCmd(AuditLogStore audit) {
        this.audit = audit;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"history").requires(src -> Perms.has(src, "messentials.history.use", 2))).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> this.show((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.show((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page"))))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"historyrecent").requires(src -> Perms.has(src, "messentials.history.use", 2))).executes(ctx -> this.showRecent((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.showRecent((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"page")))));
    }

    private int show(CommandContext<CommandSourceStack> ctx, int page) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        String name = StringArgumentType.getString(ctx, (String)"player");
        GameProfile prof = src.getServer().getProfileCache().get(name).orElse(null);
        if (prof == null) {
            src.sendFailure((Component)Component.literal((String)"\u00a7cUnknown profile."));
            return 0;
        }
        List<AuditLogStore.Entry> all = this.audit.byTarget(prof.getId(), Integer.MAX_VALUE);
        if (all.isEmpty()) {
            src.sendSuccess(() -> Component.literal((String)("\u00a77No history for \u00a7e" + name)), false);
            return 1;
        }
        Collections.reverse(all);
        int maxPage = (int)Math.ceil((double)all.size() / 10.0);
        page = Math.min(Math.max(page, 1), Math.max(maxPage, 1));
        int from = (page - 1) * 10;
        int to = Math.min(from + 10, all.size());
        List<AuditLogStore.Entry> slice = all.subList(from, to);
        SimpleDateFormat df = HistoryCmd.utc();
        int finalPage = page;
        src.sendSuccess(() -> Component.literal((String)("\u00a7aHistory for \u00a7e" + name + " \u00a77(page \u00a7e" + finalPage + "\u00a77/\u00a7e" + maxPage + "\u00a77)")), false);
        for (AuditLogStore.Entry e : slice) {
            src.sendSuccess(() -> Component.literal((String)HistoryCmd.formatLine(e, df)), false);
        }
        if (page < maxPage) {
            int finalPage1 = page;
            src.sendSuccess(() -> Component.literal((String)("\u00a77Next: \u00a7e/history " + name + " " + (finalPage1 + 1))), false);
        }
        return 1;
    }

    private int showRecent(CommandContext<CommandSourceStack> ctx, int page) {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        List<AuditLogStore.Entry> all = this.audit.recent(5000);
        if (all.isEmpty()) {
            src.sendSuccess(() -> Component.literal((String)"\u00a77No recent actions."), false);
            return 1;
        }
        int maxPage = (int)Math.ceil((double)all.size() / 10.0);
        page = Math.min(Math.max(page, 1), Math.max(maxPage, 1));
        int from = (page - 1) * 10;
        int to = Math.min(from + 10, all.size());
        List<AuditLogStore.Entry> slice = all.subList(from, to);
        SimpleDateFormat df = HistoryCmd.utc();
        int finalPage = page;
        src.sendSuccess(() -> Component.literal((String)("\u00a7aRecent moderation actions \u00a77(page \u00a7e" + finalPage + "\u00a77/\u00a7e" + maxPage + "\u00a77)")), false);
        for (AuditLogStore.Entry e : slice) {
            src.sendSuccess(() -> Component.literal((String)HistoryCmd.formatLine(e, df)), false);
        }
        if (page < maxPage) {
            int finalPage1 = page;
            src.sendSuccess(() -> Component.literal((String)("\u00a77Next: \u00a7e/historyrecent " + (finalPage1 + 1))), false);
        }
        return 1;
    }

    private static SimpleDateFormat utc() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        return df;
    }

    private static String formatLine(AuditLogStore.Entry e, SimpleDateFormat df) {
        String who;
        String when = df.format(new Date(e.at)) + " UTC";
        String until = e.until == null ? "" : " \u00a77until \u00a7e" + df.format(new Date(e.until)) + " UTC";
        String string = who = e.actor == null ? "Console" : e.actor.toString().substring(0, 8);
        String target = e.targetName != null ? e.targetName : (e.target == null ? "-" : e.target.toString().substring(0, 8));
        String ip = e.ip != null ? " \u00a77ip \u00a7e" + e.ip : "";
        String extra = e.extra != null && !e.extra.isBlank() ? " \u00a77| \u00a7f" + e.extra : "";
        String reason = e.reason == null || e.reason.isBlank() ? "" : " \u00a77| \u00a7f" + e.reason;
        return "\u00a77- \u00a7b" + e.action + " \u00a78| \u00a77" + when + " \u00a78| \u00a77by \u00a7e" + who + " \u00a78| \u00a77target \u00a7e" + target + until + ip + extra + reason;
    }
}

