/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.mod;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.alphine.mysticessentials.storage.PunishStore;
import com.alphine.mysticessentials.util.DurationUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public class IpBanCmds {
    private final PunishStore store;
    private final AuditLogStore audit;

    public IpBanCmds(PunishStore store, AuditLogStore audit) {
        this.store = store;
        this.audit = audit;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ipban").requires(src -> Perms.has(src, "messentials.ipban.use", 2))).then(Commands.argument((String)"ip", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            String ip = StringArgumentType.getString((CommandContext)ctx, (String)"ip");
            String reason = StringArgumentType.getString((CommandContext)ctx, (String)"reason");
            PunishStore.Ban b = new PunishStore.Ban();
            b.ip = ip;
            b.actor = src.getPlayerOrException().getUUID();
            b.reason = reason;
            b.at = System.currentTimeMillis();
            b.until = null;
            this.store.banIp(b);
            src.sendSuccess(() -> Component.literal((String)("\u00a7aIP banned \u00a7e" + ip)), false);
            this.audit.log(AuditLogStore.make("IPBAN", src.getPlayerOrException().getUUID(), null, null, reason, null, ip, null));
            return 1;
        }))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tempipban").requires(src -> Perms.has(src, "messentials.tempipban.use", 2))).then(Commands.argument((String)"ip", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"duration", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            String ip = StringArgumentType.getString((CommandContext)ctx, (String)"ip");
            String durStr = StringArgumentType.getString((CommandContext)ctx, (String)"duration");
            String reason = StringArgumentType.getString((CommandContext)ctx, (String)"reason");
            long ms = DurationUtil.parseToMillis(durStr);
            if (ms <= 0L) {
                src.sendFailure((Component)Component.literal((String)"\u00a7cInvalid duration."));
                return 0;
            }
            PunishStore.Ban b = new PunishStore.Ban();
            b.ip = ip;
            b.actor = src.getPlayerOrException().getUUID();
            b.reason = reason;
            b.at = System.currentTimeMillis();
            b.until = b.at + ms;
            this.store.banIp(b);
            src.sendSuccess(() -> Component.literal((String)("\u00a7aTemp IP banned \u00a7e" + ip + " \u00a77for \u00a7e" + durStr)), false);
            this.audit.log(AuditLogStore.make("TEMPIPBAN", src.getPlayerOrException().getUUID(), null, null, reason, b.until, ip, null));
            return 1;
        })))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unbanip").requires(src -> Perms.has(src, "messentials.unban.use", 2))).then(Commands.argument((String)"ip", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            String ip = StringArgumentType.getString((CommandContext)ctx, (String)"ip");
            this.store.unbanIp(ip);
            src.sendSuccess(() -> Component.literal((String)("\u00a7aUnbanned IP \u00a7e" + ip)), false);
            this.audit.log(AuditLogStore.make("UNBANIP", src.getPlayerOrException().getUUID(), null, null, null, null, ip, null));
            return 1;
        })));
    }
}

