/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.mod;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.storage.PunishStore;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class JailCmds {
    private final PunishStore store;
    private final PlayerDataStore pdata;
    private final AuditLogStore audit;

    public JailCmds(PunishStore store, PlayerDataStore pdata, AuditLogStore audit) {
        this.store = store;
        this.pdata = pdata;
        this.audit = audit;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setjail").requires(src -> Perms.has(src, "messentials.jail.set", 2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            BlockPos pos = p.blockPosition();
            PunishStore.Point pt = new PunishStore.Point();
            pt.dim = p.serverLevel().dimension().location().toString();
            pt.x = (double)pos.getX() + 0.5;
            pt.y = pos.getY();
            pt.z = (double)pos.getZ() + 0.5;
            pt.yaw = p.getYRot();
            pt.pitch = p.getXRot();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            this.store.setJail(name, pt);
            p.displayClientMessage((Component)Component.literal((String)("\u00a7aJail \u00a7e" + name + " \u00a7asaved.")), false);
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"deljail").requires(src -> Perms.has(src, "messentials.jail.del", 2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            boolean ok = this.store.delJail(StringArgumentType.getString((CommandContext)ctx, (String)"name"));
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(ok ? "\u00a7aDeleted jail." : "\u00a7cNo such jail.")), false);
            return ok ? 1 : 0;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"jail").requires(src -> Perms.has(src, "messentials.jail.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"jailName", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String jail = StringArgumentType.getString((CommandContext)ctx, (String)"jailName");
            Optional<PunishStore.Point> opt = this.store.getJail(jail);
            if (opt.isEmpty()) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cJail not found."), false);
                return 0;
            }
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            PunishStore.Point p = opt.get();
            ResourceLocation id = ResourceLocation.tryParse((String)p.dim);
            if (id == null) {
                actor.displayClientMessage((Component)Component.literal((String)("\u00a7cBad dimension id for jail: " + p.dim)), false);
                return 0;
            }
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
            ServerLevel level = actor.getServer().getLevel(key);
            if (level == null) {
                actor.displayClientMessage((Component)Component.literal((String)("\u00a7cWorld missing for jail: " + p.dim)), false);
                return 0;
            }
            this.store.jail(target.getUUID(), jail);
            Teleports.pushBackAndTeleport(target, level, p.x, p.y, p.z, p.yaw, p.pitch, this.pdata);
            target.displayClientMessage((Component)Component.literal((String)("\u00a7cYou have been jailed at \u00a7e" + jail)), false);
            actor.displayClientMessage((Component)Component.literal((String)("\u00a7aJailed \u00a7e" + name + " \u00a77at \u00a7e" + jail)), false);
            this.audit.log(AuditLogStore.make("JAIL", actor.getUUID(), target.getUUID(), target.getName().getString(), null, null, null, jail));
            return 1;
        }))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unjail").requires(src -> Perms.has(src, "messentials.jail.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer target = src.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                src.sendFailure((Component)Component.literal((String)"\u00a7cPlayer not found."));
                return 0;
            }
            this.store.unjail(target.getUUID());
            src.sendSuccess(() -> Component.literal((String)("\u00a7aUnjailed \u00a7e" + name)), false);
            this.audit.log(AuditLogStore.make("UNJAIL", src.getPlayerOrException().getUUID(), target.getUUID(), target.getName().getString(), null, null, null, null));
            return 1;
        })));
    }
}

