/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.mod;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.alphine.mysticessentials.util.ModerationPerms;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class KickCmd {
    private final AuditLogStore audit;

    public KickCmd(AuditLogStore audit) {
        this.audit = audit;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"kick").requires(src -> Perms.has(src, "messentials.kick.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String reason = StringArgumentType.getString((CommandContext)ctx, (String)"reason");
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (ModerationPerms.exempt(target, "kick")) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cTarget is exempt."), false);
                return 0;
            }
            target.connection.disconnect((Component)Component.literal((String)("\u00a7cKicked: \u00a7f" + reason)));
            actor.displayClientMessage((Component)Component.literal((String)("\u00a7aKicked \u00a7e" + name)), false);
            this.audit.log(AuditLogStore.make("KICK", actor.getUUID(), target.getUUID(), target.getName().getString(), reason, null, null, null));
            return 1;
        }))));
    }
}

