/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.mod;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.alphine.mysticessentials.storage.PunishStore;
import com.alphine.mysticessentials.util.DurationUtil;
import com.alphine.mysticessentials.util.ModerationPerms;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Date;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class MuteCmds {
    private final PunishStore store;
    private final AuditLogStore audit;

    public MuteCmds(PunishStore store, AuditLogStore audit) {
        this.store = store;
        this.audit = audit;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"mute").requires(src -> Perms.has(src, "messentials.mute.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"durationOrPerm", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String token = StringArgumentType.getString((CommandContext)ctx, (String)"durationOrPerm");
            String reason = StringArgumentType.getString((CommandContext)ctx, (String)"reason");
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (ModerationPerms.exempt(target, "mute")) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cTarget is exempt."), false);
                return 0;
            }
            long ms = "perm".equalsIgnoreCase(token) ? 0L : DurationUtil.parseToMillis(token);
            PunishStore.Mute m = new PunishStore.Mute();
            m.target = target.getUUID();
            m.actor = actor.getUUID();
            m.reason = reason;
            m.at = System.currentTimeMillis();
            m.until = ms <= 0L ? null : Long.valueOf(m.at + ms);
            this.store.mute(m);
            target.displayClientMessage((Component)Component.literal((String)("\u00a7cYou have been muted" + (String)(m.until != null ? " until \u00a7e" + String.valueOf(new Date(m.until)) : " permanently") + "\u00a7c: \u00a7f" + reason)), false);
            actor.displayClientMessage((Component)Component.literal((String)("\u00a7aMuted \u00a7e" + name + (String)(m.until != null ? " \u00a77for \u00a7e" + token : " \u00a77(permanent)"))), false);
            this.audit.log(AuditLogStore.make(m.until == null ? "MUTE" : "TEMPMUTE", actor.getUUID(), target.getUUID(), target.getName().getString(), reason, m.until, null, null));
            return 1;
        })))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"unmute").requires(src -> Perms.has(src, "messentials.unmute.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            CommandSourceStack src = (CommandSourceStack)ctx.getSource();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            GameProfile profile = src.getServer().getProfileCache().get(name).orElse(null);
            if (profile == null) {
                src.sendFailure((Component)Component.literal((String)"\u00a7cUnknown profile."));
                return 0;
            }
            this.store.unmute(profile.getId());
            src.sendSuccess(() -> Component.literal((String)("\u00a7aUnmuted \u00a7e" + name)), false);
            this.audit.log(AuditLogStore.make("UNMUTE", src.getPlayerOrException().getUUID(), profile.getId(), profile.getName(), null, null, null, null));
            return 1;
        })));
    }
}

