/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.mod;

import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.AuditLogStore;
import com.alphine.mysticessentials.storage.PunishStore;
import com.alphine.mysticessentials.util.ModerationPerms;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class WarnCmd {
    private final PunishStore store;
    private final AuditLogStore audit;

    public WarnCmd(PunishStore store, AuditLogStore audit) {
        this.store = store;
        this.audit = audit;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warn").requires(src -> Perms.has(src, "messentials.warn.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"reason", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String reason = StringArgumentType.getString((CommandContext)ctx, (String)"reason");
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (ModerationPerms.exempt(target, "warn")) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cTarget is exempt."), false);
                return 0;
            }
            PunishStore.Warning w = this.store.addWarning(target.getUUID(), actor.getUUID(), reason);
            actor.displayClientMessage((Component)Component.literal((String)("\u00a7aWarned \u00a7e" + target.getName().getString() + " \u00a77[id: \u00a7e" + w.id + "\u00a77]")), false);
            target.displayClientMessage((Component)Component.literal((String)("\u00a7cYou have been warned: \u00a7e" + reason)), false);
            this.audit.log(AuditLogStore.make("WARN", actor.getUUID(), target.getUUID(), target.getName().getString(), reason, null, null, null));
            return 1;
        }))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warnings").requires(src -> Perms.has(src, "messentials.warnings.use", 0))).executes(ctx -> {
            ServerPlayer viewer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            if (!Perms.has((CommandSourceStack)ctx.getSource(), Arrays.toString(new String[]{"messentials.warnings.list.self", "messentials.warnings.list", "messentials.admin", "messentials.*"}), 0)) {
                viewer.displayClientMessage((Component)Component.literal((String)"\u00a7cYou don't have permission to view your warnings."), false);
                return 0;
            }
            return WarnCmd.showWarnings(this.store, viewer, viewer.getUUID(), viewer.getName().getString());
        })).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer viewer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer target = viewer.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                viewer.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            boolean isSelf = target.getUUID().equals(viewer.getUUID());
            if (isSelf) {
                if (!Perms.has((CommandSourceStack)ctx.getSource(), Arrays.toString(new String[]{"messentials.warnings.list.self", "messentials.warnings.list", "messentials.admin", "messentials.*"}), 0)) {
                    viewer.displayClientMessage((Component)Component.literal((String)"\u00a7cYou don't have permission to view your warnings."), false);
                    return 0;
                }
            } else if (!Perms.has((CommandSourceStack)ctx.getSource(), Arrays.toString(new String[]{"messentials.warnings.list.others", "messentials.admin", "messentials.*"}), 2)) {
                viewer.displayClientMessage((Component)Component.literal((String)"\u00a7cYou don't have permission to view others' warnings."), false);
                return 0;
            }
            return WarnCmd.showWarnings(this.store, viewer, target.getUUID(), target.getName().getString());
        }))).then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(ctx -> {
            ServerPlayer viewer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            if (!Perms.has((CommandSourceStack)ctx.getSource(), Arrays.toString(new String[]{"messentials.warnings.list.self", "messentials.warnings.list", "messentials.admin", "messentials.*"}), 0)) {
                viewer.displayClientMessage((Component)Component.literal((String)"\u00a7cYou don't have permission to view your warnings."), false);
                return 0;
            }
            return WarnCmd.showWarnings(this.store, viewer, viewer.getUUID(), viewer.getName().getString());
        })).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer viewer = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer target = viewer.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                viewer.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            boolean isSelf = target.getUUID().equals(viewer.getUUID());
            if (isSelf) {
                if (!Perms.has((CommandSourceStack)ctx.getSource(), Arrays.toString(new String[]{"messentials.warnings.list.self", "messentials.warnings.list", "messentials.admin", "messentials.*"}), 0)) {
                    viewer.displayClientMessage((Component)Component.literal((String)"\u00a7cYou don't have permission to view your warnings."), false);
                    return 0;
                }
            } else if (!Perms.has((CommandSourceStack)ctx.getSource(), Arrays.toString(new String[]{"messentials.warnings.list.others", "messentials.admin", "messentials.*"}), 2)) {
                viewer.displayClientMessage((Component)Component.literal((String)"\u00a7cYou don't have permission to view others' warnings."), false);
                return 0;
            }
            return WarnCmd.showWarnings(this.store, viewer, target.getUUID(), target.getName().getString());
        }))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"pardon").requires(src -> Perms.has(src, "messentials.pardon.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            String id = StringArgumentType.getString((CommandContext)ctx, (String)"id");
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            boolean ok = this.store.pardonWarning(target.getUUID(), id);
            actor.displayClientMessage((Component)Component.literal((String)(ok ? "\u00a7aRemoved warning \u00a7e" + id : "\u00a7cNo warning with id \u00a7e" + id)), false);
            this.audit.log(AuditLogStore.make("PARDON", actor.getUUID(), target.getUUID(), target.getName().getString(), "warning:" + id, null, null, null));
            return ok ? 1 : 0;
        }))));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warningsclear").requires(src -> Perms.has(src, "messentials.warnings.clear", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer actor = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer target = actor.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                actor.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            boolean ok = this.store.clearWarnings(target.getUUID());
            actor.displayClientMessage((Component)Component.literal((String)(ok ? "\u00a7aCleared warnings." : "\u00a77No warnings to clear.")), false);
            this.audit.log(AuditLogStore.make("WARNINGS_CLEAR", actor.getUUID(), target.getUUID(), target.getName().getString(), null, null, null, null));
            return 1;
        })));
    }

    private static int showWarnings(PunishStore store, ServerPlayer viewer, UUID targetId, String targetName) {
        List<PunishStore.Warning> list = store.getWarnings(targetId);
        if (list.isEmpty()) {
            viewer.displayClientMessage((Component)Component.literal((String)"\u00a77No warnings."), false);
            return 1;
        }
        viewer.displayClientMessage((Component)Component.literal((String)("\u00a7aWarnings for \u00a7e" + targetName + "\u00a7a:")), false);
        for (PunishStore.Warning w : list) {
            viewer.displayClientMessage((Component)Component.literal((String)("\u00a77- \u00a7e" + w.id + " \u00a77| " + String.valueOf(new Date(w.at)) + " \u00a77| \u00a7f" + w.reason)), false);
        }
        return 1;
    }
}

