/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.tp;

import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class BackCmds {
    private final PlayerDataStore pdata;

    public BackCmds(PlayerDataStore pdata) {
        this.pdata = pdata;
    }

    private static boolean featureOn() {
        MEConfig c = MEConfig.INSTANCE;
        return c == null || c.features == null || c.features.enableHomesWarpsTP;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"back").requires(src -> Perms.has(src, "messentials.back.use", 0))).executes(ctx -> {
            if (!BackCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Optional<PlayerDataStore.LastLoc> ol = this.pdata.popBack(p.getUUID());
            if (ol.isEmpty()) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a77No previous location."), false);
                return 0;
            }
            PlayerDataStore.LastLoc l = ol.get();
            ResourceLocation id = ResourceLocation.tryParse((String)l.dim);
            if (id == null) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cBad dimension id: " + l.dim)), false);
                return 0;
            }
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
            ServerLevel level = p.getServer().getLevel(key);
            if (level == null) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cWorld missing: " + l.dim)), false);
                return 0;
            }
            Teleports.pushBackAndTeleport(p, level, l.x, l.y, l.z, l.yaw, l.pitch, this.pdata);
            p.displayClientMessage((Component)Component.literal((String)"\u00a7aReturned to previous location."), false);
            return 1;
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"deathback").requires(src -> Perms.has(src, "messentials.deathback.use", 0))).executes(ctx -> {
            if (!BackCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Optional<PlayerDataStore.LastLoc> od = this.pdata.getDeath(p.getUUID());
            if (od.isEmpty()) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a77No death location recorded."), false);
                return 0;
            }
            PlayerDataStore.LastLoc l = od.get();
            ResourceLocation id = ResourceLocation.tryParse((String)l.dim);
            if (id == null) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cBad dimension id: " + l.dim)), false);
                return 0;
            }
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
            ServerLevel level = p.getServer().getLevel(key);
            if (level == null) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cWorld missing: " + l.dim)), false);
                return 0;
            }
            Teleports.pushBackAndTeleport(p, level, l.x, l.y, l.z, l.yaw, l.pitch, this.pdata);
            p.displayClientMessage((Component)Component.literal((String)"\u00a7aTeleported to last death location."), false);
            return 1;
        }));
    }
}

