/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.tp;

import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.Bypass;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.storage.SpawnStore;
import com.alphine.mysticessentials.teleport.CooldownManager;
import com.alphine.mysticessentials.teleport.WarmupManager;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class SpawnCmds {
    private final SpawnStore spawn;
    private final CooldownManager cd;
    private final WarmupManager warm;
    private final PlayerDataStore pdata;

    public SpawnCmds(SpawnStore s, CooldownManager cd, WarmupManager warm, PlayerDataStore pdata) {
        this.spawn = s;
        this.cd = cd;
        this.warm = warm;
        this.pdata = pdata;
    }

    private static boolean featureOn() {
        MEConfig c = MEConfig.INSTANCE;
        return c == null || c.features == null || c.features.enableHomesWarpsTP;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn").requires(src -> Perms.has(src, "messentials.spawn.use", 0))).executes(ctx -> {
            if (!SpawnCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            SpawnStore.Point s = this.spawn.get();
            if (s == null) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cSpawn is not set."), false);
                return 0;
            }
            long now = System.currentTimeMillis();
            boolean bypassCd = Bypass.cooldown((CommandSourceStack)ctx.getSource());
            if (!bypassCd && this.cd.getDefaultSeconds("spawn") > 0 && !this.cd.checkAndStampDefault(p.getUUID(), "spawn", now)) {
                long rem = this.cd.remaining(p.getUUID(), "spawn", now);
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cCooldown: \u00a7e" + rem + "s")), false);
                return 0;
            }
            int warmSec = MEConfig.INSTANCE != null ? MEConfig.INSTANCE.getWarmup("spawn") : 0;
            Runnable tp = () -> {
                ResourceLocation id = ResourceLocation.tryParse((String)s.dim);
                if (id == null) {
                    p.displayClientMessage((Component)Component.literal((String)("\u00a7cBad dimension id: " + s.dim)), false);
                    return;
                }
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
                ServerLevel level = p.getServer().getLevel(key);
                if (level == null) {
                    p.displayClientMessage((Component)Component.literal((String)("\u00a7cWorld missing: " + s.dim)), false);
                    return;
                }
                Teleports.pushBackAndTeleport(p, level, s.x, s.y, s.z, s.yaw, s.pitch, this.pdata);
            };
            if (Bypass.warmup((CommandSourceStack)ctx.getSource())) {
                tp.run();
            } else {
                this.warm.startOrBypass(((CommandSourceStack)ctx.getSource()).getServer(), p, warmSec, tp);
            }
            return 1;
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setspawn").requires(src -> Perms.has(src, "messentials.spawn.set", 2))).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            BlockPos pos = p.blockPosition();
            SpawnStore.Point s = new SpawnStore.Point();
            s.dim = p.serverLevel().dimension().location().toString();
            s.x = (double)pos.getX() + 0.5;
            s.y = pos.getY();
            s.z = (double)pos.getZ() + 0.5;
            s.yaw = p.getYRot();
            s.pitch = p.getXRot();
            this.spawn.set(s);
            p.displayClientMessage((Component)Component.literal((String)"\u00a7aSpawn set."), false);
            return 1;
        }));
    }
}

