/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.tp;

import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.Bypass;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.teleport.CooldownManager;
import com.alphine.mysticessentials.teleport.WarmupManager;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class TpDirectCmds {
    private final CooldownManager cd;
    private final WarmupManager warm;
    private final PlayerDataStore pdata;

    public TpDirectCmds(CooldownManager cd, WarmupManager warm, PlayerDataStore pdata) {
        this.cd = cd;
        this.warm = warm;
        this.pdata = pdata;
    }

    private static boolean featureOn() {
        MEConfig c = MEConfig.INSTANCE;
        return c == null || c.features == null || c.features.enableHomesWarpsTP;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tp").requires(src -> Perms.has(src, "messentials.tp.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            if (!TpDirectCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer target = p.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (p.getUUID().equals(target.getUUID())) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cYou are already at your own location."), false);
                return 0;
            }
            long now = System.currentTimeMillis();
            if (!Bypass.cooldown((CommandSourceStack)ctx.getSource()) && this.cd.getDefaultSeconds("tp") > 0 && !this.cd.checkAndStampDefault(p.getUUID(), "tp", now)) {
                long rem = this.cd.remaining(p.getUUID(), "tp", now);
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cCooldown: \u00a7e" + rem + "s")), false);
                return 0;
            }
            int warmSec = MEConfig.INSTANCE != null ? MEConfig.INSTANCE.getWarmup("tp") : 0;
            Runnable tp = () -> Teleports.pushBackAndTeleport(p, target.serverLevel(), target.getX(), target.getY(), target.getZ(), target.getYRot(), target.getXRot(), this.pdata);
            if (Bypass.warmup((CommandSourceStack)ctx.getSource())) {
                tp.run();
            } else {
                this.warm.startOrBypass(((CommandSourceStack)ctx.getSource()).getServer(), p, warmSec, tp);
            }
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tphere").requires(src -> Perms.has(src, "messentials.tphere.use", 2))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            if (!TpDirectCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer target = p.getServer().getPlayerList().getPlayerByName(name);
            if (target == null) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (p.getUUID().equals(target.getUUID())) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cThat's you."), false);
                return 0;
            }
            Teleports.pushBack(target, this.pdata);
            target.teleportTo(p.serverLevel(), p.getX(), p.getY(), p.getZ(), p.getYRot(), p.getXRot());
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpo").requires(src -> Perms.has(src, "messentials.tpo.use", 2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            if (!TpDirectCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Optional profileOpt = p.getServer().getProfileCache().get(name);
            if (profileOpt.isEmpty()) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cNo such player profile."), false);
                return 0;
            }
            GameProfile profile = (GameProfile)profileOpt.get();
            Optional<PlayerDataStore.LastLoc> ol = this.pdata.getLast(profile.getId());
            if (ol.isEmpty()) {
                p.displayClientMessage((Component)Component.literal((String)"\u00a7cNo last known location for that player."), false);
                return 0;
            }
            PlayerDataStore.LastLoc l = ol.get();
            ResourceLocation id = ResourceLocation.tryParse((String)l.dim);
            if (id == null) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cBad dimension id: " + l.dim)), false);
                return 0;
            }
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
            ServerLevel level = p.getServer().getLevel(key);
            if (level == null) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cWorld missing: " + l.dim)), false);
                return 0;
            }
            Teleports.pushBackAndTeleport(p, level, l.x, l.y, l.z, l.yaw, l.pitch, this.pdata);
            p.displayClientMessage((Component)Component.literal((String)("\u00a7aTeleported to \u00a7e" + name + "\u00a7a's last location.")), false);
            return 1;
        })));
    }
}

