/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.tp;

import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.teleport.TpaManager;
import com.alphine.mysticessentials.teleport.WarmupManager;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class TpaCmds {
    private final TpaManager tpa;
    private final WarmupManager warm;
    private final PlayerDataStore pdata;

    public TpaCmds(TpaManager tpa, WarmupManager warm, PlayerDataStore pdata) {
        this.tpa = tpa;
        this.warm = warm;
        this.pdata = pdata;
    }

    private static boolean featureOn() {
        MEConfig c = MEConfig.INSTANCE;
        return c == null || c.features == null || c.features.enableHomesWarpsTP;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpa").requires(src -> Perms.has(src, "messentials.tpa.use", 0))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            if (!TpaCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer from = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"player");
            ServerPlayer to = from.getServer().getPlayerList().getPlayerByName(name);
            if (to == null) {
                from.displayClientMessage((Component)Component.literal((String)"\u00a7cPlayer not found."), false);
                return 0;
            }
            if (to.getUUID().equals(from.getUUID())) {
                from.displayClientMessage((Component)Component.literal((String)"\u00a7cYou cannot send TPA to yourself."), false);
                return 0;
            }
            PlayerDataStore.Flags flags = this.pdata.getFlags(to.getUUID());
            if (flags != null && flags.tpToggle) {
                from.displayClientMessage((Component)Component.literal((String)"\u00a7cThat player is not accepting TPA requests."), false);
                return 0;
            }
            if (flags != null && flags.tpAuto) {
                Runnable tp = () -> Teleports.pushBackAndTeleport(from, to.serverLevel(), to.getX(), to.getY(), to.getZ(), to.getYRot(), to.getXRot(), this.pdata);
                int warmSec = MEConfig.INSTANCE != null ? MEConfig.INSTANCE.getWarmup("tpa") : 0;
                this.warm.startOrBypass(((CommandSourceStack)ctx.getSource()).getServer(), from, warmSec, () -> {
                    tp.run();
                    from.displayClientMessage((Component)Component.literal((String)("\u00a7aAuto-accepted. Teleporting to \u00a7e" + to.getName().getString())), false);
                    to.displayClientMessage((Component)Component.literal((String)("\u00a77Auto-accepted TPA from \u00a7e" + from.getName().getString())), false);
                });
                return 1;
            }
            this.tpa.request(from.getUUID(), to.getUUID(), 60L);
            from.displayClientMessage((Component)Component.literal((String)("\u00a7aTPA request sent to \u00a7e" + to.getName().getString())), false);
            to.displayClientMessage((Component)Component.literal((String)("\u00a7e" + from.getName().getString() + " \u00a77requested to teleport to you. \u00a7a/tpaccept \u00a77or \u00a7c/tpdeny")), false);
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpaccept").requires(src -> Perms.has(src, "messentials.tpaccept.use", 0))).executes(ctx -> {
            if (!TpaCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer to = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Optional<TpaManager.Req> req = this.tpa.consume(to.getUUID());
            if (req.isEmpty()) {
                to.displayClientMessage((Component)Component.literal((String)"\u00a7cNo pending requests."), false);
                return 0;
            }
            ServerPlayer from = to.getServer().getPlayerList().getPlayer(req.get().from);
            if (from == null) {
                to.displayClientMessage((Component)Component.literal((String)"\u00a7cRequester offline."), false);
                return 0;
            }
            int warmSec = MEConfig.INSTANCE != null ? MEConfig.INSTANCE.getWarmup("tpa") : 0;
            Runnable tp = () -> Teleports.pushBackAndTeleport(from, to.serverLevel(), to.getX(), to.getY(), to.getZ(), to.getYRot(), to.getXRot(), this.pdata);
            this.warm.startOrBypass(((CommandSourceStack)ctx.getSource()).getServer(), from, warmSec, tp);
            to.displayClientMessage((Component)Component.literal((String)"\u00a7aAccepted request."), false);
            from.displayClientMessage((Component)Component.literal((String)("\u00a7aTeleporting to \u00a7e" + to.getName().getString())), false);
            return 1;
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpdeny").requires(src -> Perms.has(src, "messentials.tpdeny.use", 0))).executes(ctx -> {
            if (!TpaCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer to = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            Optional<TpaManager.Req> req = this.tpa.consume(to.getUUID());
            if (req.isEmpty()) {
                to.displayClientMessage((Component)Component.literal((String)"\u00a7cNo pending requests."), false);
                return 0;
            }
            to.displayClientMessage((Component)Component.literal((String)"\u00a7cDenied request."), false);
            return 1;
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tptoggle").requires(src -> Perms.has(src, "messentials.tptoggle.use", 0))).executes(ctx -> {
            if (!TpaCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            PlayerDataStore.Flags f = this.pdata.getFlags(p.getUUID());
            f.tpToggle = !f.tpToggle;
            this.pdata.saveFlags(p.getUUID(), f);
            p.displayClientMessage((Component)Component.literal((String)("\u00a77TPA Toggle: " + (f.tpToggle ? "\u00a7cOFF" : "\u00a7aON"))), false);
            return 1;
        }));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"tpauto").requires(src -> Perms.has(src, "messentials.tpauto.use", 0))).executes(ctx -> {
            if (!TpaCmds.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            PlayerDataStore.Flags f = this.pdata.getFlags(p.getUUID());
            f.tpAuto = !f.tpAuto;
            this.pdata.saveFlags(p.getUUID(), f);
            p.displayClientMessage((Component)Component.literal((String)("\u00a77TPA Auto-Accept: " + (f.tpAuto ? "\u00a7aON" : "\u00a7cOFF"))), false);
            return 1;
        }));
    }
}

