/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.commands.tp;

import com.alphine.mysticessentials.MysticEssentialsCommon;
import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.Bypass;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.storage.WarpsStore;
import com.alphine.mysticessentials.teleport.CooldownManager;
import com.alphine.mysticessentials.teleport.WarmupManager;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class WarpCmd {
    private final WarpsStore warps;
    private final CooldownManager cd;
    private final WarmupManager warm;
    private final PlayerDataStore pdata;
    private static final SuggestionProvider<CommandSourceStack> WARP_SUGGEST = (ctx, b) -> {
        MysticEssentialsCommon common = MysticEssentialsCommon.get();
        if (common != null && common.warps != null) {
            for (String n : common.warps.names()) {
                b.suggest(n);
            }
        }
        return b.buildFuture();
    };

    public WarpCmd(WarpsStore w, CooldownManager cd, WarmupManager warm, PlayerDataStore pdata) {
        this.warps = w;
        this.cd = cd;
        this.warm = warm;
        this.pdata = pdata;
    }

    private static boolean featureOn() {
        MEConfig c = MEConfig.INSTANCE;
        return c == null || c.features == null || c.features.enableHomesWarpsTP;
    }

    public void register(CommandDispatcher<CommandSourceStack> d) {
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warp").requires(src -> Perms.has(src, "messentials.warp.use", 0))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(WARP_SUGGEST).executes(ctx -> {
            if (!WarpCmd.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            Optional<WarpsStore.Warp> ow = this.warps.get(name);
            if (ow.isEmpty()) {
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cUnknown warp: \u00a7e" + name)), false);
                return 0;
            }
            WarpsStore.Warp w = ow.get();
            long now = System.currentTimeMillis();
            if (!Bypass.cooldown((CommandSourceStack)ctx.getSource()) && this.cd.getDefaultSeconds("warp") > 0 && !this.cd.checkAndStampDefault(p.getUUID(), "warp", now)) {
                long rem = this.cd.remaining(p.getUUID(), "warp", now);
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cCooldown: \u00a7e" + rem + "s")), false);
                return 0;
            }
            int warmSec = MEConfig.INSTANCE != null ? MEConfig.INSTANCE.getWarmup("warp") : 0;
            Runnable tp = () -> {
                ResourceLocation id = ResourceLocation.tryParse((String)w.dim);
                if (id == null) {
                    p.displayClientMessage((Component)Component.literal((String)("\u00a7cBad dimension id: " + w.dim)), false);
                    return;
                }
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
                ServerLevel level = p.getServer().getLevel(key);
                if (level == null) {
                    p.displayClientMessage((Component)Component.literal((String)("\u00a7cWorld missing: " + w.dim)), false);
                    return;
                }
                Teleports.pushBackAndTeleport(p, level, w.x, w.y, w.z, w.yaw, w.pitch, this.pdata);
            };
            if (Bypass.warmup((CommandSourceStack)ctx.getSource())) {
                tp.run();
            } else {
                this.warm.startOrBypass(((CommandSourceStack)ctx.getSource()).getServer(), p, warmSec, tp);
            }
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"setwarp").requires(src -> Perms.has(src, "messentials.warp.set", 2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            BlockPos pos = p.blockPosition();
            WarpsStore.Warp w = new WarpsStore.Warp();
            w.name = name;
            w.dim = p.serverLevel().dimension().location().toString();
            w.x = (double)pos.getX() + 0.5;
            w.y = pos.getY();
            w.z = (double)pos.getZ() + 0.5;
            w.yaw = p.getYRot();
            w.pitch = p.getXRot();
            this.warps.set(w);
            p.displayClientMessage((Component)Component.literal((String)("\u00a7aWarp \u00a7e" + name + " \u00a7asaved.")), false);
            return 1;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"delwarp").requires(src -> Perms.has(src, "messentials.warp.del", 2))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests(WARP_SUGGEST).executes(ctx -> {
            ServerPlayer p = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            boolean ok = this.warps.del(name);
            p.displayClientMessage((Component)Component.literal((String)(ok ? "\u00a7aDeleted warp \u00a7e" + name : "\u00a7cNo warp named \u00a7e" + name)), false);
            return ok ? 1 : 0;
        })));
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"warps").requires(src -> Perms.has(src, "messentials.warp.list", 0))).executes(ctx -> {
            if (!WarpCmd.featureOn()) {
                ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)"\u00a7cTeleport features are disabled by config."));
                return 0;
            }
            List list = this.warps.names().stream().sorted().toList();
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)(list.isEmpty() ? "\u00a77No warps." : "\u00a7aWarps: \u00a7e" + String.join((CharSequence)"\u00a77, \u00a7e", list))), false);
            return 1;
        }));
    }
}

