/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MEConfig {
    public static MEConfig INSTANCE;
    private static final Gson GSON;
    @SerializedName(value="cooldowns")
    public Cooldowns cooldowns = new Cooldowns();
    @SerializedName(value="warmups")
    public Warmups warmups = new Warmups();
    @SerializedName(value="limits")
    public Limits limits = new Limits();
    @SerializedName(value="homes")
    public Homes homes = new Homes();
    @SerializedName(value="features")
    public Features features = new Features();
    @SerializedName(value="permissions")
    public Permissions permissions = new Permissions();
    @SerializedName(value="afk")
    public Afk afk = new Afk();
    private transient Path filePath;

    public static MEConfig load(Path configDir) {
        try {
            MEConfig cfg;
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path file = configDir.resolve("config.json");
            if (Files.exists(file, new LinkOption[0])) {
                try (BufferedReader r = Files.newBufferedReader(file);){
                    cfg = (MEConfig)GSON.fromJson((Reader)r, MEConfig.class);
                }
            } else {
                cfg = new MEConfig();
                cfg.homes.groups.put("group1", 3);
                cfg.homes.groups.put("vip", 5);
                cfg.homes.groups.put("mvp", 10);
                cfg.save(file);
            }
            cfg.filePath = file;
            INSTANCE = cfg;
            return cfg;
        }
        catch (IOException e) {
            throw new RuntimeException("[MysticEssentials] Failed to load config!", e);
        }
    }

    public void save() {
        if (this.filePath != null) {
            this.save(this.filePath);
        }
    }

    private void save(Path file) {
        try (BufferedWriter w = Files.newBufferedWriter(file, new OpenOption[0]);){
            GSON.toJson((Object)this, (Appendable)w);
        }
        catch (IOException e) {
            System.err.println("[MysticEssentials] Failed to save config: " + e.getMessage());
        }
    }

    public void reload() {
        if (this.filePath == null) {
            return;
        }
        try (BufferedReader r = Files.newBufferedReader(this.filePath);){
            MEConfig x = (MEConfig)GSON.fromJson((Reader)r, MEConfig.class);
            if (x != null) {
                this.cooldowns = x.cooldowns;
                this.warmups = x.warmups;
                this.limits = x.limits;
                this.homes = x.homes;
                this.features = x.features;
                this.permissions = x.permissions;
                this.afk = x.afk;
            }
        }
        catch (IOException e) {
            System.err.println("[MysticEssentials] Failed to reload config: " + e.getMessage());
        }
    }

    public int getCooldown(String key) {
        return switch (key.toLowerCase(Locale.ROOT)) {
            case "home" -> this.cooldowns.home;
            case "warp" -> this.cooldowns.warp;
            case "tp" -> this.cooldowns.tp;
            case "tpa" -> this.cooldowns.tpa;
            case "spawn" -> this.cooldowns.spawn;
            default -> 0;
        };
    }

    public int getWarmup(String key) {
        return switch (key.toLowerCase(Locale.ROOT)) {
            case "home" -> this.warmups.home;
            case "warp" -> this.warmups.warp;
            case "tp" -> this.warmups.tp;
            case "tpa" -> this.warmups.tpa;
            case "spawn" -> this.warmups.spawn;
            default -> 0;
        };
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    }

    public static class Cooldowns {
        public int home = 3;
        public int warp = 3;
        public int tp = 3;
        public int tpa = 3;
        public int spawn = 3;
    }

    public static class Warmups {
        public int home = 2;
        public int warp = 2;
        public int tp = 2;
        public int tpa = 2;
        public int spawn = 2;
    }

    public static class Limits {
        public int defaultHomes = 1;
        public int maxJumpDistance = 64;
        public int nearRadius = 64;
    }

    public static class Homes {
        public int defaultHomes = 1;
        public Map<String, Integer> groups = new LinkedHashMap<String, Integer>();
        public int numericCap = 64;
    }

    public static class Features {
        public boolean cancelWarmupOnMove = true;
        public boolean cancelWarmupOnDamage = true;
        public boolean useLuckPermsHomeLimits = true;
        public boolean enableModerationSystem = true;
        public boolean enableMiscCommands = true;
        public boolean enableKits = true;
        public boolean enableHomesWarpsTP = true;
        public boolean enableAfkSystem = true;
    }

    public static class Permissions {
        public String nearExempt = "messentials.near.exempt";
        public String godBypassDamage = "messentials.god.bypass.damage";
        public String cooldownBypass = "messentials.bypass.cooldown";
        public String warmupBypass = "messentials.bypass.warmup";
        public String modBypass = "messentials.mod.bypass";
        public String homesMultipleBase = "messentials.homes.multiple";
    }

    public static class Afk {
        public boolean enabled = true;
        public int autoAfkSeconds = 240;
        public boolean respectAutoEnablePermission = true;
        public boolean respectExemptPermission = true;
        public int idleKickSeconds = 0;
        public String idleKickReason = "<red>Kicked for being AFK too long.";
        public String defaultMessage = "<gray>I'm currently AFK.";
        public String notifyFormat = "<gray><sender> \u2192 <target>: <msg>";
        public TeleportPoint fallback = new TeleportPoint("world", 0.5, 64.0, 0.5, 0.0f, 0.0f);
        public int rewardTickSeconds = 1;
        public Map<String, AfkPool> pools = new LinkedHashMap<String, AfkPool>();
    }

    public static class ItemSpec {
        public String type = "minecraft:stone";
        public int amount = 1;
        public String nbt = "{}";
    }

    public static class AfkReward {
        public String id = "default";
        public int everySeconds = 60;
        public List<String> commands = new ArrayList<String>();
        public List<ItemSpec> items = new ArrayList<ItemSpec>();
    }

    public static class AfkPool {
        public boolean enabled = true;
        public PoolBox region = new PoolBox();
        public TeleportPoint teleport = new TeleportPoint("world", 0.5, 64.0, 0.5, 0.0f, 0.0f);
        public boolean requirePermission = true;
        public boolean allowChatInside = true;
        public boolean allowEnterExitFreely = true;
        public List<AfkReward> rewards = new ArrayList<AfkReward>();
    }

    public static class Vec3i {
        public int x;
        public int y;
        public int z;

        public Vec3i() {
        }

        public Vec3i(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class PoolBox {
        public String world;
        public Vec3i min = new Vec3i(0, 0, 0);
        public Vec3i max = new Vec3i(0, 0, 0);
    }

    public static class TeleportPoint {
        public String world;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;

        public TeleportPoint() {
        }

        public TeleportPoint(String world, double x, double y, double z, float yaw, float pitch) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.yaw = yaw;
            this.pitch = pitch;
        }
    }
}

