/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.inv;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public final class InvseeSessions {
    private static final Map<UUID, UUID> VIEWER_TO_TARGET = new ConcurrentHashMap<UUID, UUID>();

    private InvseeSessions() {
    }

    public static void open(ServerPlayer viewer, ServerPlayer target) {
        VIEWER_TO_TARGET.put(viewer.getUUID(), target.getUUID());
    }

    public static void close(ServerPlayer viewer) {
        VIEWER_TO_TARGET.remove(viewer.getUUID());
    }

    public static void tick(MinecraftServer server) {
        VIEWER_TO_TARGET.keySet().removeIf(viewerId -> {
            ServerPlayer viewer = server.getPlayerList().getPlayer(viewerId);
            if (viewer == null) {
                return true;
            }
            if (viewer.containerMenu == null) {
                return true;
            }
            if (!viewer.containerMenu.stillValid((Player)viewer)) {
                return true;
            }
            try {
                viewer.containerMenu.broadcastChanges();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        });
    }
}

