/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.inv;

import java.util.Objects;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TargetInventoryContainer
implements Container {
    private final Player target;
    private final boolean editable;
    public static final int SIZE = 54;

    public TargetInventoryContainer(Player target, boolean editable) {
        this.target = Objects.requireNonNull(target);
        this.editable = editable;
    }

    public int getContainerSize() {
        return 54;
    }

    public boolean isEmpty() {
        return this.target.getInventory().isEmpty() && this.target.getOffhandItem().isEmpty() && ((ItemStack)this.target.getInventory().armor.get(0)).isEmpty() && ((ItemStack)this.target.getInventory().armor.get(1)).isEmpty() && ((ItemStack)this.target.getInventory().armor.get(2)).isEmpty() && ((ItemStack)this.target.getInventory().armor.get(3)).isEmpty();
    }

    private boolean isFiller(int slot) {
        return slot >= 41 && slot < 54;
    }

    private ItemStack getMapped(int slot) {
        Inventory inv = this.target.getInventory();
        if (slot >= 0 && slot <= 35) {
            return inv.getItem(slot);
        }
        if (slot >= 36 && slot <= 39) {
            return (ItemStack)inv.armor.get(slot - 36);
        }
        if (slot == 40) {
            return this.target.getOffhandItem();
        }
        return ItemStack.EMPTY;
    }

    private void setMapped(int slot, ItemStack stack) {
        Inventory inv = this.target.getInventory();
        if (slot >= 0 && slot <= 35) {
            inv.setItem(slot, stack);
            return;
        }
        if (slot >= 36 && slot <= 39) {
            inv.armor.set(slot - 36, (Object)stack);
            return;
        }
        if (slot == 40) {
            this.target.setItemInHand(InteractionHand.OFF_HAND, stack);
            return;
        }
    }

    public ItemStack getItem(int slot) {
        return this.getMapped(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        if (!this.editable || this.isFiller(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack cur = this.getMapped(slot);
        if (cur.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack split = cur.split(amount);
        this.setChanged();
        return split;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        if (!this.editable || this.isFiller(slot)) {
            return ItemStack.EMPTY;
        }
        ItemStack cur = this.getMapped(slot);
        if (cur.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack ret = cur.copy();
        this.setMapped(slot, ItemStack.EMPTY);
        this.setChanged();
        return ret;
    }

    public void setItem(int slot, ItemStack stack) {
        if (!this.editable || this.isFiller(slot)) {
            return;
        }
        this.setMapped(slot, stack);
        this.setChanged();
    }

    public void setChanged() {
        this.target.getInventory().setChanged();
        this.target.containerMenu.broadcastChanges();
    }

    public boolean stillValid(Player viewer) {
        return viewer.isAlive() && this.target.isAlive();
    }

    public void startOpen(Player viewer) {
    }

    public void stopOpen(Player viewer) {
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return this.editable && !this.isFiller(slot);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public void clearContent() {
        if (!this.editable) {
            return;
        }
        for (int i = 0; i < 54; ++i) {
            if (this.isFiller(i)) continue;
            this.setMapped(i, ItemStack.EMPTY);
        }
        this.setChanged();
    }
}

