/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.neoforge;

import com.alphine.mysticessentials.MysticEssentialsCommon;
import com.alphine.mysticessentials.inv.InvseeSessions;
import com.alphine.mysticessentials.neoforge.platform.NeoForgeModInfoService;
import com.alphine.mysticessentials.storage.PlayerDataStore;
import com.alphine.mysticessentials.storage.PunishStore;
import com.alphine.mysticessentials.util.AfkPingUtil;
import com.alphine.mysticessentials.util.DurationUtil;
import com.alphine.mysticessentials.util.Teleports;
import com.mojang.brigadier.CommandDispatcher;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.ServerChatEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@Mod(value="mysticessentials")
public class MysticEssentialsNeoForge {
    private int afkTickAccum = 0;
    private final Map<UUID, Vec3> afkLastPos = new HashMap<UUID, Vec3>();
    private final Map<UUID, float[]> afkLastRot = new HashMap<UUID, float[]>();

    public MysticEssentialsNeoForge() {
        MysticEssentialsCommon.get().setModInfoService(new NeoForgeModInfoService());
        NeoForge.EVENT_BUS.addListener(this::onServerAboutToStart);
        NeoForge.EVENT_BUS.addListener(this::onRegisterCommands);
        NeoForge.EVENT_BUS.addListener(this::onServerStopping);
        NeoForge.EVENT_BUS.addListener(this::onIncomingDamage);
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedOut);
        NeoForge.EVENT_BUS.addListener(this::onPlayerDeath);
        NeoForge.EVENT_BUS.addListener(this::onServerTickPost);
        NeoForge.EVENT_BUS.addListener(this::onPlayerContainerClose);
        NeoForge.EVENT_BUS.addListener(this::onChat);
        NeoForge.EVENT_BUS.addListener(this::onPlayerTickPost);
        NeoForge.EVENT_BUS.addListener(this::onPlayerChangedDimension);
        NeoForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
        NeoForge.EVENT_BUS.addListener(this::onDamagePost);
    }

    private void onServerAboutToStart(ServerAboutToStartEvent e) {
        MysticEssentialsCommon.get().serverStarting(e.getServer());
    }

    public void onRegisterCommands(RegisterCommandsEvent e) {
        MysticEssentialsCommon common = MysticEssentialsCommon.get();
        Path cfgDir = FMLPaths.CONFIGDIR.get().resolve("mysticessentials").normalize();
        common.ensureCoreServices(cfgDir);
        common.registerCommands((CommandDispatcher<CommandSourceStack>)e.getDispatcher());
    }

    private void onServerStopping(ServerStoppingEvent e) {
        MysticEssentialsCommon.get().serverStopping();
    }

    private void onIncomingDamage(LivingIncomingDamageEvent evt) {
        LivingEntity livingEntity = evt.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer p = (ServerPlayer)livingEntity;
        if (MysticEssentialsCommon.get().god.isGod(p.getUUID())) {
            evt.setCanceled(true);
        }
    }

    private void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer p = (ServerPlayer)player;
        MysticEssentialsCommon common = MysticEssentialsCommon.get();
        common.onPlayerQuit(p);
        PlayerDataStore.LastLoc l = new PlayerDataStore.LastLoc();
        l.dim = p.serverLevel().dimension().location().toString();
        l.x = p.getX();
        l.y = p.getY();
        l.z = p.getZ();
        l.yaw = p.getYRot();
        l.pitch = p.getXRot();
        l.when = System.currentTimeMillis();
        common.pdata.setLast(p.getUUID(), l);
        InvseeSessions.close(p);
    }

    private void onPlayerDeath(LivingDeathEvent e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer p = (ServerPlayer)livingEntity;
        PlayerDataStore.LastLoc l = new PlayerDataStore.LastLoc();
        l.dim = p.serverLevel().dimension().location().toString();
        l.x = p.getX();
        l.y = p.getY();
        l.z = p.getZ();
        l.yaw = p.getYRot();
        l.pitch = p.getXRot();
        l.when = System.currentTimeMillis();
        MysticEssentialsCommon.get().pdata.setDeath(p.getUUID(), l);
    }

    private void onServerTickPost(ServerTickEvent.Post e) {
        InvseeSessions.tick(e.getServer());
        if (++this.afkTickAccum >= 20) {
            this.afkTickAccum = 0;
            MysticEssentialsCommon.get().serverTick1s(e.getServer());
        }
    }

    private void onPlayerContainerClose(PlayerContainerEvent.Close e) {
        Player player = e.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            MysticEssentialsCommon.get().onPlayerInteract(sp);
            InvseeSessions.close(sp);
        }
    }

    private void onChat(ServerChatEvent e) {
        ServerPlayer p = e.getPlayer();
        PunishStore ps = MysticEssentialsCommon.get().punish;
        MysticEssentialsCommon.get().onPlayerChat(p);
        Optional<PunishStore.Mute> om = ps.getMute(p.getUUID());
        if (om.isPresent()) {
            PunishStore.Mute m = om.get();
            if (m.until == null || System.currentTimeMillis() < m.until) {
                e.setCanceled(true);
                long rem = m.until == null ? -1L : m.until - System.currentTimeMillis();
                p.displayClientMessage((Component)Component.literal((String)("\u00a7cYou are muted" + (String)(rem > 0L ? " \u00a77(" + DurationUtil.fmtRemaining(rem) + ")" : " \u00a77(permanent)") + ".")), false);
                return;
            }
            ps.unmute(p.getUUID());
        }
        Component comp = e.getMessage();
        String raw = comp.getString();
        AfkPingUtil.handleChatMention(p.getServer(), p, raw);
    }

    private void onPlayerTickPost(PlayerTickEvent.Post e) {
        PunishStore ps;
        boolean rotated;
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer p = (ServerPlayer)player;
        UUID id = p.getUUID();
        Vec3 curPos = p.position();
        Vec3 lastPos = this.afkLastPos.get(id);
        float yRot = p.getYRot();
        float xRot = p.getXRot();
        float[] lastRot = this.afkLastRot.get(id);
        boolean moved = lastPos == null || curPos.distanceToSqr(lastPos) > 4.0E-4;
        boolean bl = rotated = lastRot == null || Math.abs(lastRot[0] - yRot) > 0.1f || Math.abs(lastRot[1] - xRot) > 0.1f;
        if (moved || rotated) {
            MysticEssentialsCommon.get().onPlayerMove(p);
            this.afkLastPos.put(id, curPos);
            this.afkLastRot.put(id, new float[]{yRot, xRot});
        }
        if ((ps = MysticEssentialsCommon.get().punish).isFrozen(p.getUUID())) {
            p.setDeltaMovement(0.0, 0.0, 0.0);
            p.hurtMarked = true;
        }
    }

    private void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent e) {
        Player player = e.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer p = (ServerPlayer)player;
        MysticEssentialsCommon common = MysticEssentialsCommon.get();
        PunishStore ps = common.punish;
        Optional<String> oj = ps.getJailed(p.getUUID());
        if (oj.isEmpty()) {
            return;
        }
        String name = oj.get();
        Optional<PunishStore.Point> opt = ps.getJail(name);
        if (opt.isEmpty()) {
            return;
        }
        PunishStore.Point pt = opt.get();
        ResourceLocation id = ResourceLocation.tryParse((String)pt.dim);
        if (id == null) {
            return;
        }
        ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)id);
        ServerLevel lvl = p.getServer().getLevel(key);
        if (lvl != null) {
            Teleports.pushBackAndTeleport(p, lvl, pt.x, pt.y, pt.z, pt.yaw, pt.pitch, common.pdata);
        }
    }

    private void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        String ip;
        Optional<PunishStore.Ban> ib;
        ServerPlayer p = (ServerPlayer)e.getEntity();
        PunishStore ps = MysticEssentialsCommon.get().punish;
        MysticEssentialsCommon.get().onPlayerJoin(p);
        Optional<PunishStore.Ban> ub = ps.getUuidBan(p.getUUID());
        if (ub.isPresent()) {
            PunishStore.Ban b = ub.get();
            if (b.until == null || System.currentTimeMillis() < b.until) {
                p.connection.disconnect((Component)Component.literal((String)("\u00a7cBanned: \u00a7f" + b.reason)));
                return;
            }
            ps.unbanUuid(p.getUUID());
        }
        if ((ib = ps.getIpBan(ip = p.getIpAddress())).isPresent()) {
            PunishStore.Ban b = ib.get();
            if (b.until == null || System.currentTimeMillis() < b.until) {
                p.connection.disconnect((Component)Component.literal((String)("\u00a7cIP Banned: \u00a7f" + b.reason)));
            } else {
                ps.unbanIp(ip);
            }
        }
    }

    private void onDamagePost(LivingDamageEvent.Post e) {
        LivingEntity livingEntity = e.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            MysticEssentialsCommon.get().warmups.onDamaged(sp);
        }
    }
}

