/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.perm;

import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.model.user.User;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;

public final class Perms {
    private Perms() {
    }

    public static boolean isConsole(CommandSourceStack src) {
        return src.getEntity() == null;
    }

    public static boolean has(CommandSourceStack src, String node, int opLevelFallback) {
        if (Perms.isConsole(src)) {
            return true;
        }
        try {
            return Perms.has(src.getPlayerOrException(), node, opLevelFallback);
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean has(ServerPlayer p, String node, int opLevelFallback) {
        try {
            LuckPerms lp = LuckPermsProvider.get();
            User user = lp.getUserManager().getUser(p.getUUID());
            if (user != null) {
                CachedPermissionData data = user.getCachedData().getPermissionData();
                if (data.checkPermission(node).asBoolean()) {
                    return true;
                }
                if (data.checkPermission("messentials.admin").asBoolean()) {
                    return true;
                }
                if (data.checkPermission("messentials.*").asBoolean()) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return p.hasPermissions(opLevelFallback);
    }

    public static boolean hasBypass(ServerPlayer p, String bypassNode, int opLevelFallback) {
        if (bypassNode == null || bypassNode.isBlank()) {
            return false;
        }
        return Perms.has(p, bypassNode, opLevelFallback);
    }
}

