/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.alphine.mysticessentials.config.MEConfig;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class AfkPoolsStore {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path file;
    private final Map<String, MEConfig.AfkPool> pools = new LinkedHashMap<String, MEConfig.AfkPool>();

    public AfkPoolsStore(Path cfgDir) {
        this.file = cfgDir.resolve("afk_pools.json");
        this.load();
    }

    public synchronized void load() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.file, new LinkOption[0])) {
                this.save();
                return;
            }
            try (BufferedReader r = Files.newBufferedReader(this.file);){
                Type type = new TypeToken<Map<String, Object>>(this){}.getType();
                Map root = (Map)this.gson.fromJson((Reader)r, type);
                this.pools.clear();
                if (root != null) {
                    for (Map.Entry e : root.entrySet()) {
                        MEConfig.AfkPool p = (MEConfig.AfkPool)this.gson.fromJson(this.gson.toJsonTree(e.getValue()), MEConfig.AfkPool.class);
                        this.sanitizePool(p);
                        this.pools.put((String)e.getKey(), p);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void save() {
        try (BufferedWriter w = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            LinkedHashMap<String, MEConfig.AfkPool> out = new LinkedHashMap<String, MEConfig.AfkPool>();
            for (Map.Entry<String, MEConfig.AfkPool> e : this.pools.entrySet()) {
                out.put(e.getKey(), e.getValue());
            }
            this.gson.toJson(out, (Appendable)w);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized Map<String, MEConfig.AfkPool> viewAll() {
        return Collections.unmodifiableMap(new LinkedHashMap<String, MEConfig.AfkPool>(this.pools));
    }

    public synchronized Optional<MEConfig.AfkPool> get(String name) {
        return Optional.ofNullable(this.pools.get(name));
    }

    public synchronized void put(String name, MEConfig.AfkPool pool) {
        this.sanitizePool(pool);
        this.pools.put(name, pool);
        this.save();
    }

    public synchronized boolean remove(String name) {
        boolean b;
        boolean bl = b = this.pools.remove(name) != null;
        if (b) {
            this.save();
        }
        return b;
    }

    public synchronized MEConfig.AfkPool getOrCreate(String name) {
        return this.pools.computeIfAbsent(name, n -> {
            MEConfig.AfkPool p = new MEConfig.AfkPool();
            p.enabled = true;
            if (p.region == null) {
                p.region = new MEConfig.PoolBox();
            }
            if (p.region.min == null) {
                p.region.min = new MEConfig.Vec3i(0, 0, 0);
            }
            if (p.region.max == null) {
                p.region.max = new MEConfig.Vec3i(0, 0, 0);
            }
            if (p.teleport == null) {
                p.teleport = new MEConfig.TeleportPoint("minecraft:overworld", 0.5, 64.0, 0.5, 0.0f, 0.0f);
            }
            return p;
        });
    }

    public synchronized void setEnabled(String name, boolean enabled) {
        this.getOrCreate((String)name).enabled = enabled;
        this.save();
    }

    public synchronized void setRequirePermission(String name, boolean require) {
        this.getOrCreate((String)name).requirePermission = require;
        this.save();
    }

    public synchronized void setAllowChat(String name, boolean allow) {
        this.getOrCreate((String)name).allowChatInside = allow;
        this.save();
    }

    public synchronized void setAllowExit(String name, boolean allow) {
        this.getOrCreate((String)name).allowEnterExitFreely = allow;
        this.save();
    }

    public synchronized void setRegion(String name, String world, int x1, int y1, int z1, int x2, int y2, int z2) {
        MEConfig.AfkPool p = this.getOrCreate(name);
        if (p.region == null) {
            p.region = new MEConfig.PoolBox();
        }
        p.region.world = world;
        int minX = Math.min(x1, x2);
        int minY = Math.min(y1, y2);
        int minZ = Math.min(z1, z2);
        int maxX = Math.max(x1, x2);
        int maxY = Math.max(y1, y2);
        int maxZ = Math.max(z1, z2);
        p.region.min = new MEConfig.Vec3i(minX, minY, minZ);
        p.region.max = new MEConfig.Vec3i(maxX, maxY, maxZ);
        this.save();
    }

    public synchronized void setTeleport(String name, MEConfig.TeleportPoint tp) {
        MEConfig.AfkPool p = this.getOrCreate(name);
        p.teleport = tp;
        this.save();
    }

    public synchronized void setTeleport(String name, String world, double x, double y, double z, float yaw, float pitch) {
        this.setTeleport(name, new MEConfig.TeleportPoint(world, x, y, z, yaw, pitch));
    }

    public synchronized MEConfig.AfkReward addOrUpdateRewardTrack(String name, String trackId, int everySeconds) {
        MEConfig.AfkPool p = this.getOrCreate(name);
        if (p.rewards == null) {
            p.rewards = new ArrayList<MEConfig.AfkReward>();
        }
        for (MEConfig.AfkReward r : p.rewards) {
            if (r.id == null || !r.id.equalsIgnoreCase(trackId)) continue;
            r.everySeconds = everySeconds;
            this.save();
            return r;
        }
        MEConfig.AfkReward r = new MEConfig.AfkReward();
        r.id = trackId;
        r.everySeconds = everySeconds;
        if (r.commands == null) {
            r.commands = new ArrayList<String>();
        }
        if (r.items == null) {
            r.items = new ArrayList<MEConfig.ItemSpec>();
        }
        p.rewards.add(r);
        this.save();
        return r;
    }

    public synchronized void addRewardCommand(String name, String trackId, String command) {
        MEConfig.AfkReward r = this.addOrUpdateRewardTrack(name, trackId, Math.max(1, this.getTrackEverySeconds(name, trackId)));
        if (r.commands == null) {
            r.commands = new ArrayList<String>();
        }
        r.commands.add(command);
        this.save();
    }

    public synchronized void addRewardItem(String name, String trackId, String material, int amount, String nbtJson) {
        MEConfig.AfkReward r = this.addOrUpdateRewardTrack(name, trackId, Math.max(1, this.getTrackEverySeconds(name, trackId)));
        if (r.items == null) {
            r.items = new ArrayList<MEConfig.ItemSpec>();
        }
        MEConfig.ItemSpec it = new MEConfig.ItemSpec();
        it.type = material;
        it.amount = Math.max(1, amount);
        it.nbt = nbtJson == null || nbtJson.isBlank() ? "{}" : nbtJson;
        r.items.add(it);
        this.save();
    }

    public synchronized boolean removeRewardTrack(String name, String trackId) {
        MEConfig.AfkPool p = this.pools.get(name);
        if (p == null || p.rewards == null) {
            return false;
        }
        boolean removed = p.rewards.removeIf(r -> trackId.equalsIgnoreCase(r.id));
        if (removed) {
            this.save();
        }
        return removed;
    }

    private int getTrackEverySeconds(String name, String trackId) {
        MEConfig.AfkPool p = this.pools.get(name);
        if (p == null || p.rewards == null) {
            return 60;
        }
        for (MEConfig.AfkReward r : p.rewards) {
            if (r.id == null || !r.id.equalsIgnoreCase(trackId)) continue;
            return Math.max(1, r.everySeconds);
        }
        return 60;
    }

    private void sanitizePool(MEConfig.AfkPool p) {
        if (p == null) {
            return;
        }
        if (p.region == null) {
            p.region = new MEConfig.PoolBox();
        }
        if (p.region.min == null) {
            p.region.min = new MEConfig.Vec3i(0, 0, 0);
        }
        if (p.region.max == null) {
            p.region.max = new MEConfig.Vec3i(0, 0, 0);
        }
        if (p.teleport == null) {
            p.teleport = new MEConfig.TeleportPoint("minecraft:overworld", 0.5, 64.0, 0.5, 0.0f, 0.0f);
        }
        if (p.rewards == null) {
            p.rewards = new ArrayList<MEConfig.AfkReward>();
        }
        int minX = Math.min(p.region.min.x, p.region.max.x);
        int minY = Math.min(p.region.min.y, p.region.max.y);
        int minZ = Math.min(p.region.min.z, p.region.max.z);
        int maxX = Math.max(p.region.min.x, p.region.max.x);
        int maxY = Math.max(p.region.min.y, p.region.max.y);
        int maxZ = Math.max(p.region.min.z, p.region.max.z);
        p.region.min = new MEConfig.Vec3i(minX, minY, minZ);
        p.region.max = new MEConfig.Vec3i(maxX, maxY, maxZ);
    }
}

