/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class AuditLogStore {
    private final Path file;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final List<Entry> entries = new ArrayList<Entry>();

    public AuditLogStore(Path cfgDir) {
        this.file = cfgDir.resolve("audit_log.json");
        this.load();
    }

    public synchronized void log(Entry e) {
        this.entries.add(e);
        this.save();
    }

    public synchronized List<Entry> byTarget(UUID target, int limit) {
        return this.entries.stream().filter(e -> Objects.equals(e.target, target)).sorted(Comparator.comparingLong(en -> en.at)).limit(Math.max(limit, 1000)).collect(Collectors.toList());
    }

    public synchronized List<Entry> recent(int limit) {
        return this.entries.stream().sorted(Comparator.comparingLong(e -> e.at).reversed()).limit(limit).collect(Collectors.toList());
    }

    private void load() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.file, new LinkOption[0])) {
                this.save();
                return;
            }
            try (BufferedReader r = Files.newBufferedReader(this.file);){
                Entry[] arr = (Entry[])this.gson.fromJson((Reader)r, Entry[].class);
                this.entries.clear();
                if (arr != null) {
                    this.entries.addAll(Arrays.asList(arr));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        try (BufferedWriter w = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            this.gson.toJson(this.entries, (Appendable)w);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Entry make(String action, UUID actor, UUID target, String targetName, String reason, Long until, String ip, String extra) {
        Entry e = new Entry();
        e.at = System.currentTimeMillis();
        e.action = action;
        e.actor = actor;
        e.target = target;
        e.targetName = targetName;
        e.reason = reason;
        e.until = until;
        e.ip = ip;
        e.extra = extra;
        return e;
    }

    public static final class Entry {
        public long at;
        public String action;
        public UUID actor;
        public UUID target;
        public String targetName;
        public String ip;
        public String reason;
        public Long until;
        public String extra;
    }
}

