/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.alphine.mysticessentials.storage.PlayerDataStore;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public final class HomesStore {
    private final PlayerDataStore store;

    public HomesStore(PlayerDataStore store) {
        this.store = store;
    }

    public void load() {
    }

    public void save() {
    }

    private static PlayerDataStore.Home toPD(Home h) {
        PlayerDataStore.Home p = new PlayerDataStore.Home();
        p.name = h.name;
        p.dim = h.dim;
        p.x = h.x;
        p.y = h.y;
        p.z = h.z;
        p.yaw = h.yaw;
        p.pitch = h.pitch;
        return p;
    }

    private static Home fromPD(PlayerDataStore.Home p) {
        Home h = new Home();
        h.name = p.name;
        h.dim = p.dim;
        h.x = p.x;
        h.y = p.y;
        h.z = p.z;
        h.yaw = p.yaw;
        h.pitch = p.pitch;
        return h;
    }

    public synchronized void set(UUID id, Home h) {
        this.store.setHome(id, HomesStore.toPD(h));
    }

    public synchronized Optional<Home> get(UUID id, String name) {
        return this.store.getHome(id, name).map(HomesStore::fromPD);
    }

    public synchronized boolean delete(UUID id, String name) {
        return this.store.delHome(id, name);
    }

    public synchronized Collection<Home> all(UUID id) {
        return this.store.allHomes(id).stream().map(HomesStore::fromPD).toList();
    }

    public synchronized Set<String> names(UUID id) {
        return this.store.homeNames(id);
    }

    public static final class Home {
        public String name;
        public String dim;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;
    }
}

