/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.alphine.mysticessentials.storage.PlayerDataStore;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public final class KitPlayerStore {
    private final PlayerDataStore store;

    public KitPlayerStore(PlayerDataStore store) {
        this.store = store;
    }

    public synchronized PlayerData get(UUID uuid) {
        Map<String, Long> lc = this.store.getAllKitLast(uuid);
        Set<String> uo = this.store.getAllKitsUsedOnce(uuid);
        return new PlayerData(Collections.unmodifiableMap(new HashMap<String, Long>(lc)), Collections.unmodifiableSet(new HashSet<String>(uo)));
    }

    public synchronized long getLast(UUID uuid, String kit) {
        return this.store.getKitLast(uuid, kit);
    }

    public synchronized void setLast(UUID uuid, String kit, long when) {
        this.store.setKitLast(uuid, kit, when);
    }

    public synchronized boolean hasUsedOnce(UUID uuid, String kit) {
        return this.store.hasUsedKitOnce(uuid, kit);
    }

    public synchronized void markUsedOnce(UUID uuid, String kit) {
        this.store.markKitUsedOnce(uuid, kit);
    }

    public static final class PlayerData {
        public final Map<String, Long> lastClaim;
        public final Set<String> usedOnce;

        PlayerData(Map<String, Long> lc, Set<String> uo) {
            this.lastClaim = lc;
            this.usedOnce = uo;
        }
    }
}

