/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.item.ItemStack;

public class KitStore {
    private final Path file;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<String, Kit> kits = new HashMap<String, Kit>();

    public KitStore(Path cfgDir) {
        this.file = cfgDir.resolve("kits.json");
        this.load();
    }

    public synchronized List<String> names() {
        return this.kits.keySet().stream().sorted().toList();
    }

    public synchronized Optional<Kit> get(String name) {
        return Optional.ofNullable(this.kits.get(name.toLowerCase(Locale.ROOT)));
    }

    public synchronized void put(Kit k) {
        this.kits.put(k.name.toLowerCase(Locale.ROOT), k);
        this.save();
    }

    public synchronized boolean delete(String name) {
        boolean ok;
        boolean bl = ok = this.kits.remove(name.toLowerCase(Locale.ROOT)) != null;
        if (ok) {
            this.save();
        }
        return ok;
    }

    public static String stackToB64(ItemStack stack, HolderLookup.Provider provider) {
        String string;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            CompoundTag tag = (CompoundTag)stack.save(provider);
            NbtIo.writeCompressed((CompoundTag)tag, (OutputStream)baos);
            string = Base64.getEncoder().encodeToString(baos.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return "";
            }
        }
        baos.close();
        return string;
    }

    public static ItemStack b64ToStack(String b64, HolderLookup.Provider provider) {
        ItemStack itemStack;
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.getDecoder().decode(b64));
        try {
            CompoundTag tag = NbtIo.readCompressed((InputStream)bais, (NbtAccounter)NbtAccounter.unlimitedHeap());
            itemStack = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return ItemStack.EMPTY;
            }
        }
        bais.close();
        return itemStack;
    }

    private void load() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.file, new LinkOption[0])) {
                this.save();
                return;
            }
            try (BufferedReader r = Files.newBufferedReader(this.file);){
                Kit[] arr = (Kit[])this.gson.fromJson((Reader)r, Kit[].class);
                this.kits.clear();
                if (arr != null) {
                    for (Kit k : arr) {
                        this.kits.put(k.name.toLowerCase(Locale.ROOT), k);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void save() {
        try (BufferedWriter w = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            this.gson.toJson(this.kits.values(), (Appendable)w);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class Kit {
        public String name;
        public long cooldownMillis;
        public boolean oneTime;
        public List<String> itemsB64 = new ArrayList<String>();
    }
}

