/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class PlayerDataStore {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path baseDir;
    private final Path cfgDir;
    private final Map<UUID, PlayerRecord> cache = new HashMap<UUID, PlayerRecord>();

    public PlayerDataStore(Path cfgDir) {
        this.cfgDir = cfgDir;
        this.baseDir = cfgDir.resolve("playerdata");
        try {
            Files.createDirectories(this.baseDir, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.migrateOldStoresIfPresent();
    }

    public synchronized void setLast(UUID id, LastLoc l) {
        PlayerRecord r = this.rec(id);
        r.last = l;
        this.save(id, r);
    }

    public synchronized Optional<LastLoc> getLast(UUID id) {
        return Optional.ofNullable(this.rec((UUID)id).last);
    }

    public synchronized Flags getFlags(UUID id) {
        return this.rec((UUID)id).flags;
    }

    public synchronized void saveFlags(UUID id, Flags f) {
        PlayerRecord r = this.rec(id);
        r.flags = f;
        this.save(id, r);
    }

    public synchronized void setTpToggle(UUID id, boolean v) {
        PlayerRecord r = this.rec(id);
        r.flags.tpToggle = v;
        this.save(id, r);
    }

    public synchronized void setTpAuto(UUID id, boolean v) {
        PlayerRecord r = this.rec(id);
        r.flags.tpAuto = v;
        this.save(id, r);
    }

    public synchronized void pushBack(UUID id, LastLoc l) {
        PlayerRecord r = this.rec(id);
        r.back.stack.push(l);
        while (r.back.stack.size() > 20) {
            r.back.stack.removeLast();
        }
        this.save(id, r);
    }

    public synchronized Optional<LastLoc> popBack(UUID id) {
        PlayerRecord r = this.rec(id);
        if (r.back.stack.isEmpty()) {
            return Optional.empty();
        }
        LastLoc l = r.back.stack.pop();
        this.save(id, r);
        return Optional.of(l);
    }

    public synchronized Optional<LastLoc> peekBack(UUID id) {
        PlayerRecord r = this.rec(id);
        return r.back.stack.isEmpty() ? Optional.empty() : Optional.of(r.back.stack.peek());
    }

    public synchronized void setDeath(UUID id, LastLoc l) {
        PlayerRecord r = this.rec(id);
        r.back.lastDeath = l;
        this.save(id, r);
    }

    public synchronized Optional<LastLoc> getDeath(UUID id) {
        return Optional.ofNullable(this.rec((UUID)id).back.lastDeath);
    }

    public synchronized void setAfkMessage(UUID id, String msg) {
        PlayerRecord r = this.rec(id);
        r.afk.message = msg == null ? "" : msg;
        this.save(id, r);
    }

    public synchronized Optional<String> getAfkMessage(UUID id) {
        String m = this.rec((UUID)id).afk.message;
        return m == null || m.isBlank() ? Optional.empty() : Optional.of(m);
    }

    public synchronized void clearAfkMessage(UUID id) {
        PlayerRecord r = this.rec(id);
        r.afk.message = "";
        this.save(id, r);
    }

    public synchronized void setAfkReturnLoc(UUID id, LastLoc loc) {
        PlayerRecord r = this.rec(id);
        r.afk.returnLoc = loc;
        this.save(id, r);
    }

    public synchronized Optional<LastLoc> getAfkReturnLoc(UUID id) {
        return Optional.ofNullable(this.rec((UUID)id).afk.returnLoc);
    }

    public synchronized void clearAfkReturnLoc(UUID id) {
        PlayerRecord r = this.rec(id);
        r.afk.returnLoc = null;
        this.save(id, r);
    }

    public synchronized void setHome(UUID id, Home h) {
        PlayerRecord r = this.rec(id);
        String key = h.name.toLowerCase(Locale.ROOT);
        r.homes.put(key, h);
        this.save(id, r);
    }

    public synchronized Optional<Home> getHome(UUID id, String name) {
        PlayerRecord r = this.rec(id);
        Home h = r.homes.get(name.toLowerCase(Locale.ROOT));
        return Optional.ofNullable(h);
    }

    public synchronized boolean delHome(UUID id, String name) {
        boolean ok;
        PlayerRecord r = this.rec(id);
        boolean bl = ok = r.homes.remove(name.toLowerCase(Locale.ROOT)) != null;
        if (ok) {
            this.save(id, r);
        }
        return ok;
    }

    public synchronized Collection<Home> allHomes(UUID id) {
        return List.copyOf(this.rec((UUID)id).homes.values());
    }

    public synchronized Set<String> homeNames(UUID id) {
        return Set.copyOf(this.rec((UUID)id).homes.keySet());
    }

    public synchronized long getKitLast(UUID id, String kit) {
        return this.rec((UUID)id).kits.lastClaim.getOrDefault(kit.toLowerCase(Locale.ROOT), 0L);
    }

    public synchronized void setKitLast(UUID id, String kit, long when) {
        PlayerRecord r = this.rec(id);
        r.kits.lastClaim.put(kit.toLowerCase(Locale.ROOT), when);
        this.save(id, r);
    }

    public synchronized boolean hasUsedKitOnce(UUID id, String kit) {
        return this.rec((UUID)id).kits.usedOnce.contains(kit.toLowerCase(Locale.ROOT));
    }

    public synchronized void markKitUsedOnce(UUID id, String kit) {
        PlayerRecord r = this.rec(id);
        r.kits.usedOnce.add(kit.toLowerCase(Locale.ROOT));
        this.save(id, r);
    }

    public synchronized Map<String, Long> getAllKitLast(UUID id) {
        return new HashMap<String, Long>(this.rec((UUID)id).kits.lastClaim);
    }

    public synchronized Set<String> getAllKitsUsedOnce(UUID id) {
        return new HashSet<String>(this.rec((UUID)id).kits.usedOnce);
    }

    private Path fileOf(UUID id) {
        return this.baseDir.resolve(id.toString() + ".json");
    }

    private synchronized PlayerRecord rec(UUID id) {
        return this.cache.computeIfAbsent(id, this::loadOrCreate);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PlayerRecord loadOrCreate(UUID id) {
        Path f = this.fileOf(id);
        try {
            if (!Files.exists(f, new LinkOption[0])) {
                PlayerRecord pr = new PlayerRecord();
                this.save(id, pr);
                return pr;
            }
            try (BufferedReader r = Files.newBufferedReader(f);){
                PlayerRecord pr = (PlayerRecord)this.gson.fromJson((Reader)r, PlayerRecord.class);
                if (pr == null) {
                    pr = new PlayerRecord();
                }
                if (pr.schema <= 0) {
                    pr.schema = 1;
                }
                this.normalize(pr);
                PlayerRecord playerRecord = pr;
                return playerRecord;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PlayerRecord pr = new PlayerRecord();
            this.save(id, pr);
            return pr;
        }
    }

    private void normalize(PlayerRecord pr) {
        if (pr.flags == null) {
            pr.flags = new Flags();
        }
        if (pr.back == null) {
            pr.back = new BackData();
        }
        if (pr.afk == null) {
            pr.afk = new AfkSession();
        }
        if (pr.homes == null) {
            pr.homes = new HashMap<String, Home>();
        }
        if (pr.kits == null) {
            pr.kits = new KitsData();
        }
        if (pr.back.stack == null) {
            pr.back.stack = new ArrayDeque<LastLoc>();
        }
        if (pr.afk.message == null) {
            pr.afk.message = "";
        }
        if (pr.kits.lastClaim == null) {
            pr.kits.lastClaim = new HashMap<String, Long>();
        }
        if (pr.kits.usedOnce == null) {
            pr.kits.usedOnce = new HashSet<String>();
        }
    }

    private void save(UUID id, PlayerRecord r) {
        Path f = this.fileOf(id);
        try {
            Files.createDirectories(this.baseDir, new FileAttribute[0]);
            Path tmp = Files.createTempFile(this.baseDir, id.toString(), ".tmp", new FileAttribute[0]);
            try (BufferedWriter w = Files.newBufferedWriter(tmp, new OpenOption[0]);){
                this.gson.toJson((Object)r, (Appendable)w);
            }
            try {
                Files.move(tmp, f, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException amnse) {
                Files.move(tmp, f, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void saveAll() {
        for (Map.Entry<UUID, PlayerRecord> e : this.cache.entrySet()) {
            this.save(e.getKey(), e.getValue());
        }
    }

    public synchronized void save() {
        this.saveAll();
    }

    /*
     * WARNING - void declaration
     */
    private void migrateOldStoresIfPresent() {
        Path oldKits;
        PlayerRecord pr;
        UUID id;
        Path oldHomes;
        Path oldMonolith = this.cfgDir.resolve("playerdata.json");
        if (Files.exists(oldMonolith, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(oldMonolith);){
                Type type = new TypeToken<Map<String, Object>>(this){}.getType();
                Map root = (Map)this.gson.fromJson((Reader)r, type);
                if (root != null) {
                    Map L = (Map)root.get("last");
                    Map F = (Map)root.get("flags");
                    Map map = (Map)root.get("back");
                    Map A = (Map)root.get("afk");
                    HashSet uuids = new HashSet();
                    if (L != null) {
                        uuids.addAll(L.keySet());
                    }
                    if (F != null) {
                        uuids.addAll(F.keySet());
                    }
                    if (map != null) {
                        uuids.addAll(map.keySet());
                    }
                    if (A != null) {
                        uuids.addAll(A.keySet());
                    }
                    for (String string : uuids) {
                        Map m;
                        Map in;
                        void id2;
                        try {
                            UUID id22 = UUID.fromString(string);
                        }
                        catch (Exception ignore) {
                            continue;
                        }
                        PlayerRecord pr2 = this.loadOrCreate((UUID)id2);
                        if (L != null && L.containsKey(string)) {
                            pr2.last = (LastLoc)this.gson.fromJson(this.gson.toJsonTree(L.get(string)), LastLoc.class);
                        }
                        if (F != null && F.containsKey(string)) {
                            pr2.flags = (Flags)this.gson.fromJson(this.gson.toJsonTree(F.get(string)), Flags.class);
                        }
                        if (map != null && map.containsKey(string) && (in = (Map)map.get(string)) != null) {
                            List list = (List)in.get("stack");
                            if (list != null) {
                                for (Object o : list) {
                                    pr2.back.stack.addLast((LastLoc)this.gson.fromJson(this.gson.toJsonTree(o), LastLoc.class));
                                }
                            }
                            if (in.get("lastDeath") != null) {
                                pr2.back.lastDeath = (LastLoc)this.gson.fromJson(this.gson.toJsonTree(in.get("lastDeath")), LastLoc.class);
                            }
                        }
                        if (A != null && A.containsKey(string) && (m = (Map)A.get(string)) != null) {
                            if (m.get("message") != null) {
                                pr2.afk.message = String.valueOf(m.get("message"));
                            }
                            if (m.get("returnLoc") != null) {
                                pr2.afk.returnLoc = (LastLoc)this.gson.fromJson(this.gson.toJsonTree(m.get("returnLoc")), LastLoc.class);
                            }
                        }
                        this.save((UUID)id2, pr2);
                        this.cache.put((UUID)id2, pr2);
                    }
                }
                Files.move(oldMonolith, oldMonolith.resolveSibling("playerdata.json.bak"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(oldHomes = this.cfgDir.resolve("homes.json"), new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(oldHomes);){
                Type type = new TypeToken<Map<String, Map<String, Home>>>(this){}.getType();
                Map raw = (Map)this.gson.fromJson((Reader)r, type);
                if (raw != null) {
                    for (Map.Entry entry : raw.entrySet()) {
                        try {
                            id = UUID.fromString((String)entry.getKey());
                        }
                        catch (Exception ignore) {
                            continue;
                        }
                        pr = this.loadOrCreate(id);
                        for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                            String key = ((String)entry2.getKey()).toLowerCase(Locale.ROOT);
                            Home h = (Home)entry2.getValue();
                            if (h == null) continue;
                            if (h.name == null || h.name.isBlank()) {
                                h.name = (String)entry2.getKey();
                            }
                            pr.homes.put(key, h);
                        }
                        this.save(id, pr);
                        this.cache.put(id, pr);
                    }
                }
                Files.move(oldHomes, oldHomes.resolveSibling("homes.json.bak"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (Files.exists(oldKits = this.cfgDir.resolve("kits_players.json"), new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(oldKits);){
                class Root {
                    Map<String, KitsData> players = new HashMap<String, KitsData>();

                    Root(PlayerDataStore this$0) {
                    }
                }
                Root root = (Root)this.gson.fromJson((Reader)r, Root.class);
                if (root != null && root.players != null) {
                    for (Map.Entry<Object, Object> entry : root.players.entrySet()) {
                        try {
                            id = UUID.fromString((String)entry.getKey());
                        }
                        catch (Exception ignore) {
                            continue;
                        }
                        pr = this.loadOrCreate(id);
                        KitsData kd = (KitsData)entry.getValue();
                        if (kd != null) {
                            if (kd.lastClaim == null) {
                                kd.lastClaim = new HashMap<String, Long>();
                            }
                            if (kd.usedOnce == null) {
                                kd.usedOnce = new HashSet<String>();
                            }
                            HashMap hashMap = new HashMap();
                            kd.lastClaim.forEach((k, v) -> lc.put(k.toLowerCase(Locale.ROOT), v));
                            HashSet uo = new HashSet();
                            kd.usedOnce.forEach(k -> uo.add(k.toLowerCase(Locale.ROOT)));
                            pr.kits.lastClaim.putAll(hashMap);
                            pr.kits.usedOnce.addAll(uo);
                        }
                        this.save(id, pr);
                        this.cache.put(id, pr);
                    }
                }
                Files.move(oldKits, oldKits.resolveSibling("kits_players.json.bak"), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final class PlayerRecord {
        public int schema = 1;
        public LastLoc last;
        public Flags flags = new Flags();
        public BackData back = new BackData();
        public AfkSession afk = new AfkSession();
        public Map<String, Home> homes = new HashMap<String, Home>();
        public KitsData kits = new KitsData();
    }

    public static final class LastLoc {
        public String dim;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;
        public long when;
    }

    public static final class Flags {
        public boolean tpToggle = false;
        public boolean tpAuto = false;
    }

    public static final class BackData {
        public Deque<LastLoc> stack = new ArrayDeque<LastLoc>();
        public LastLoc lastDeath;
    }

    public static final class AfkSession {
        public String message = "";
        public LastLoc returnLoc;
    }

    public static final class Home {
        public String name;
        public String dim;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;
    }

    public static final class KitsData {
        public Map<String, Long> lastClaim = new HashMap<String, Long>();
        public Set<String> usedOnce = new HashSet<String>();
    }
}

