/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class PunishStore {
    private final Path file;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<UUID, List<Warning>> warnings = new HashMap<UUID, List<Warning>>();
    private final Map<UUID, Ban> uuidBans = new HashMap<UUID, Ban>();
    private final Map<String, Ban> ipBans = new HashMap<String, Ban>();
    private final Map<UUID, Mute> mutes = new HashMap<UUID, Mute>();
    private final Set<UUID> frozen = new HashSet<UUID>();
    private final Jails jails = new Jails();

    public PunishStore(Path cfgDir) {
        this.file = cfgDir.resolve("moderation.json");
        this.load();
    }

    public synchronized Warning addWarning(UUID target, UUID actor, String reason) {
        Warning w = new Warning();
        w.id = UUID.randomUUID().toString().substring(0, 8);
        w.target = target;
        w.actor = actor;
        w.reason = reason;
        w.at = System.currentTimeMillis();
        this.warnings.computeIfAbsent(target, k -> new ArrayList()).add(w);
        this.save();
        return w;
    }

    public synchronized List<Warning> getWarnings(UUID target) {
        return List.copyOf(this.warnings.getOrDefault(target, List.of()));
    }

    public synchronized boolean clearWarnings(UUID target) {
        boolean ok;
        boolean bl = ok = this.warnings.remove(target) != null;
        if (ok) {
            this.save();
        }
        return ok;
    }

    public synchronized boolean pardonWarning(UUID target, String id) {
        List<Warning> list = this.warnings.get(target);
        if (list == null) {
            return false;
        }
        boolean ok = list.removeIf(w -> w.id.equalsIgnoreCase(id));
        if (ok) {
            this.save();
        }
        return ok;
    }

    public synchronized void banUuid(Ban b) {
        this.uuidBans.put(b.target, b);
        this.save();
    }

    public synchronized void banIp(Ban b) {
        this.ipBans.put(b.ip, b);
        this.save();
    }

    public synchronized void unbanUuid(UUID t) {
        if (this.uuidBans.remove(t) != null) {
            this.save();
        }
    }

    public synchronized void unbanIp(String ip) {
        if (this.ipBans.remove(ip) != null) {
            this.save();
        }
    }

    public synchronized Optional<Ban> getUuidBan(UUID t) {
        return Optional.ofNullable(this.uuidBans.get(t));
    }

    public synchronized Optional<Ban> getIpBan(String ip) {
        return Optional.ofNullable(this.ipBans.get(ip));
    }

    public synchronized Collection<Ban> allBans() {
        ArrayList<Ban> out = new ArrayList<Ban>(this.uuidBans.values());
        out.addAll(this.ipBans.values());
        return out;
    }

    public synchronized void mute(Mute m) {
        this.mutes.put(m.target, m);
        this.save();
    }

    public synchronized void unmute(UUID t) {
        if (this.mutes.remove(t) != null) {
            this.save();
        }
    }

    public synchronized Optional<Mute> getMute(UUID t) {
        return Optional.ofNullable(this.mutes.get(t));
    }

    public synchronized boolean toggleFreeze(UUID t) {
        if (this.frozen.contains(t)) {
            this.frozen.remove(t);
            this.save();
            return false;
        }
        this.frozen.add(t);
        this.save();
        return true;
    }

    public synchronized boolean isFrozen(UUID t) {
        return this.frozen.contains(t);
    }

    public synchronized void setJail(String name, Point p) {
        this.jails.locations.put(name.toLowerCase(Locale.ROOT), p);
        this.save();
    }

    public synchronized boolean delJail(String name) {
        boolean ok;
        boolean bl = ok = this.jails.locations.remove(name.toLowerCase(Locale.ROOT)) != null;
        if (ok) {
            this.save();
        }
        return ok;
    }

    public synchronized Set<String> jailNames() {
        return Set.copyOf(this.jails.locations.keySet());
    }

    public synchronized Optional<Point> getJail(String name) {
        return Optional.ofNullable(this.jails.locations.get(name.toLowerCase(Locale.ROOT)));
    }

    public synchronized void jail(UUID u, String name) {
        this.jails.jailed.put(u, name.toLowerCase(Locale.ROOT));
        this.save();
    }

    public synchronized void unjail(UUID u) {
        if (this.jails.jailed.remove(u) != null) {
            this.save();
        }
    }

    public synchronized Optional<String> getJailed(UUID u) {
        return Optional.ofNullable(this.jails.jailed.get(u));
    }

    public synchronized void load() {
        Object root;
        BufferedReader r;
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.file, new LinkOption[0])) {
                this.save();
                return;
            }
            r = Files.newBufferedReader(this.file);
            try {
                root = (Map)this.gson.fromJson((Reader)r, Map.class);
                this.warnings.clear();
                this.uuidBans.clear();
                this.ipBans.clear();
                this.mutes.clear();
                this.frozen.clear();
            }
            finally {
                if (r != null) {
                    ((Reader)r).close();
                }
            }
        }
        catch (Exception r2) {
            // empty catch block
        }
        try {
            r = Files.newBufferedReader(this.file);
            try {
                class Root {
                    Map<String, List<Warning>> warnings = new HashMap<String, List<Warning>>();
                    Map<String, Ban> uuidBans = new HashMap<String, Ban>();
                    Map<String, Ban> ipBans = new HashMap<String, Ban>();
                    Map<String, Mute> mutes = new HashMap<String, Mute>();
                    Set<String> frozen = new HashSet<String>();
                    Jails jails = new Jails();

                    Root(PunishStore this$0) {
                    }
                }
                root = (Root)this.gson.fromJson((Reader)r, Root.class);
                if (root != null) {
                    ((Root)root).warnings.forEach((k, v) -> this.warnings.put(UUID.fromString(k), v == null ? List.of() : v));
                    ((Root)root).uuidBans.forEach((k, v) -> this.uuidBans.put(UUID.fromString(k), (Ban)v));
                    if (((Root)root).ipBans != null) {
                        this.ipBans.putAll(((Root)root).ipBans);
                    }
                    ((Root)root).mutes.forEach((k, v) -> this.mutes.put(UUID.fromString(k), (Mute)v));
                    if (((Root)root).frozen != null) {
                        ((Root)root).frozen.forEach(s -> this.frozen.add(UUID.fromString(s)));
                    }
                    if (((Root)root).jails != null) {
                        this.jails.locations = ((Root)root).jails.locations == null ? new HashMap() : ((Root)root).jails.locations;
                        this.jails.jailed = ((Root)root).jails.jailed == null ? new HashMap() : ((Root)root).jails.jailed;
                    }
                }
            }
            finally {
                if (r != null) {
                    ((Reader)r).close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void save() {
        try (BufferedWriter w = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
            LinkedHashMap W2 = new LinkedHashMap();
            this.warnings.forEach((k, v) -> W2.put(k.toString(), v));
            LinkedHashMap UB = new LinkedHashMap();
            this.uuidBans.forEach((k, v) -> UB.put(k.toString(), v));
            LinkedHashMap M = new LinkedHashMap();
            this.mutes.forEach((k, v) -> M.put(k.toString(), v));
            LinkedHashSet F = new LinkedHashSet();
            this.frozen.forEach(u -> F.add(u.toString()));
            LinkedHashMap<String, Map<Object, Object>> J = new LinkedHashMap<String, Map<Object, Object>>();
            J.put("locations", this.jails.locations);
            J.put("jailed", this.jails.jailed);
            root.put("warnings", W2);
            root.put("uuidBans", UB);
            root.put("ipBans", this.ipBans);
            root.put("mutes", M);
            root.put("frozen", F);
            root.put("jails", J);
            this.gson.toJson(root, (Appendable)w);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class Jails {
        public Map<String, Point> locations = new HashMap<String, Point>();
        public Map<UUID, String> jailed = new HashMap<UUID, String>();
    }

    public static final class Warning {
        public String id;
        public UUID target;
        public UUID actor;
        public String reason;
        public long at;
    }

    public static final class Ban {
        public UUID target;
        public String ip;
        public UUID actor;
        public String reason;
        public long at;
        public Long until;
    }

    public static final class Mute {
        public UUID target;
        public UUID actor;
        public String reason;
        public long at;
        public Long until;
    }

    public static final class Point {
        public String dim;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;
    }

    public static final class Freeze {
        public UUID target;
        public long at;
    }
}

