/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class SpawnStore {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path file;
    private Point spawn;

    public SpawnStore(Path cfgDir) {
        this.file = cfgDir.resolve("spawn.json");
        this.load();
    }

    public synchronized void set(Point p) {
        this.spawn = p;
        this.save();
    }

    public synchronized Point get() {
        return this.spawn;
    }

    public synchronized void load() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.file, new LinkOption[0])) {
                this.save();
                return;
            }
            try (BufferedReader r = Files.newBufferedReader(this.file);){
                this.spawn = (Point)this.gson.fromJson((Reader)r, Point.class);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void save() {
        try (BufferedWriter w = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            this.gson.toJson((Object)this.spawn, (Appendable)w);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class Point {
        public String dim;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;
    }
}

