/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class WarpsStore {
    private final Map<String, Warp> warps = new HashMap<String, Warp>();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Path file;

    public WarpsStore(Path cfgDir) {
        this.file = cfgDir.resolve("warps.json");
        this.load();
    }

    public synchronized void set(Warp w) {
        this.warps.put(w.name.toLowerCase(Locale.ROOT), w);
        this.save();
    }

    public synchronized Optional<Warp> get(String name) {
        return Optional.ofNullable(this.warps.get(name.toLowerCase(Locale.ROOT)));
    }

    public synchronized boolean del(String name) {
        boolean ok;
        boolean bl = ok = this.warps.remove(name.toLowerCase(Locale.ROOT)) != null;
        if (ok) {
            this.save();
        }
        return ok;
    }

    public synchronized Set<String> names() {
        return Set.copyOf(this.warps.keySet());
    }

    public synchronized Collection<Warp> all() {
        return List.copyOf(this.warps.values());
    }

    public synchronized void load() {
        try {
            Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
            if (!Files.exists(this.file, new LinkOption[0])) {
                this.save();
                return;
            }
            try (BufferedReader r = Files.newBufferedReader(this.file);){
                Type type = new TypeToken<Map<String, Warp>>(this){}.getType();
                Map in = (Map)this.gson.fromJson((Reader)r, type);
                this.warps.clear();
                if (in != null) {
                    this.warps.putAll(in);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void save() {
        try (BufferedWriter w = Files.newBufferedWriter(this.file, new OpenOption[0]);){
            this.gson.toJson(this.warps, (Appendable)w);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final class Warp {
        public String name;
        public String dim;
        public double x;
        public double y;
        public double z;
        public float yaw;
        public float pitch;
    }
}

