/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.teleport;

import com.alphine.mysticessentials.config.MEConfig;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private final Map<UUID, Map<String, Long>> map = new HashMap<UUID, Map<String, Long>>();
    private int defHome = 0;
    private int defWarp = 0;
    private int defTp = 0;
    private int defTpa = 0;
    private int defSpawn = 0;

    public boolean checkAndStamp(UUID id, String key, long nowMs, long seconds) {
        Map m = this.map.computeIfAbsent(id, k -> new HashMap());
        long until = m.getOrDefault(key, 0L);
        if (nowMs < until) {
            return false;
        }
        m.put(key, nowMs + seconds * 1000L);
        return true;
    }

    public boolean checkAndStampDefault(UUID id, String key, long nowMs) {
        return this.checkAndStamp(id, key, nowMs, this.getDefaultSeconds(key));
    }

    public long remaining(UUID id, String key, long nowMs) {
        Map<String, Long> m = this.map.get(id);
        if (m == null) {
            return 0L;
        }
        long remMs = m.getOrDefault(key, 0L) - nowMs;
        return remMs <= 0L ? 0L : (remMs + 999L) / 1000L;
    }

    public void set(UUID id, String key, long secondsFromNow, long nowMs) {
        this.map.computeIfAbsent(id, k -> new HashMap()).put(key, nowMs + Math.max(0L, secondsFromNow) * 1000L);
    }

    public void clear(UUID id, String key) {
        Map<String, Long> m = this.map.get(id);
        if (m != null) {
            m.remove(key);
        }
    }

    public void updateFromConfig() {
        MEConfig c = MEConfig.INSTANCE;
        if (c == null) {
            return;
        }
        this.defHome = Math.max(0, c.getCooldown("home"));
        this.defWarp = Math.max(0, c.getCooldown("warp"));
        this.defTp = Math.max(0, c.getCooldown("tp"));
        this.defTpa = Math.max(0, c.getCooldown("tpa"));
        this.defSpawn = Math.max(0, c.getCooldown("spawn"));
    }

    public int getDefaultSeconds(String key) {
        if (key == null) {
            return 0;
        }
        return switch (key.toLowerCase(Locale.ROOT)) {
            case "home" -> this.defHome;
            case "warp" -> this.defWarp;
            case "tp" -> this.defTp;
            case "tpa" -> this.defTpa;
            case "spawn" -> this.defSpawn;
            default -> 0;
        };
    }
}

