/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.teleport;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class TpaManager {
    private final Map<UUID, Req> incoming = new ConcurrentHashMap<UUID, Req>();

    public void request(UUID from, UUID to, long ttlSec) {
        long expiryAt = System.currentTimeMillis() + Math.max(1L, ttlSec) * 1000L;
        this.incoming.put(to, new Req(from, to, expiryAt));
    }

    public Optional<Req> peek(UUID to) {
        Req r = this.incoming.get(to);
        if (r == null) {
            return Optional.empty();
        }
        if (System.currentTimeMillis() > r.expiry) {
            this.incoming.remove(to);
            return Optional.empty();
        }
        return Optional.of(r);
    }

    public Optional<Req> consume(UUID to) {
        Req r = this.incoming.remove(to);
        if (r == null) {
            return Optional.empty();
        }
        if (System.currentTimeMillis() > r.expiry) {
            return Optional.empty();
        }
        return Optional.of(r);
    }

    public void clear(UUID to) {
        this.incoming.remove(to);
    }

    public static final class Req {
        public final UUID from;
        public final UUID to;
        public final long expiry;

        public Req(UUID f, UUID t, long e) {
            this.from = f;
            this.to = t;
            this.expiry = e;
        }
    }
}

