/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.teleport;

import com.alphine.mysticessentials.config.MEConfig;
import com.alphine.mysticessentials.perm.Bypass;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class WarmupManager {
    private final Map<UUID, W> pending = new HashMap<UUID, W>();

    public void startOrBypass(MinecraftServer server, ServerPlayer p, int seconds, Runnable task) {
        if (seconds <= 0 || Bypass.warmup(p.createCommandSourceStack())) {
            task.run();
            return;
        }
        MEConfig.Features f = MEConfig.INSTANCE != null ? MEConfig.INSTANCE.features : null;
        boolean cancelOnMove = f == null || f.cancelWarmupOnMove;
        boolean cancelOnDamage = f == null || f.cancelWarmupOnDamage;
        W w = new W(task, p.getX(), p.getY(), p.getZ(), seconds * 20, cancelOnMove, cancelOnDamage);
        this.pending.put(p.getUUID(), w);
        p.displayClientMessage((Component)Component.literal((String)("\u00a77Teleporting in \u00a7e" + seconds + "\u00a77s...")), false);
        this.schedule(server, p);
    }

    public void cancel(ServerPlayer p, String msg) {
        if (this.pending.remove(p.getUUID()) != null && msg != null && !msg.isBlank()) {
            p.displayClientMessage((Component)Component.literal((String)msg), false);
        }
    }

    public void onDamaged(ServerPlayer p) {
        W w = this.pending.get(p.getUUID());
        if (w != null && w.cancelOnDamage) {
            this.cancel(p, "\u00a7cTeleport cancelled: you took damage.");
        }
    }

    private void schedule(MinecraftServer server, ServerPlayer p) {
        server.execute(() -> {
            W w = this.pending.get(p.getUUID());
            if (w == null) {
                return;
            }
            if (w.cancelOnMove && p.distanceToSqr(w.x, w.y, w.z) > 0.01) {
                this.cancel(p, "\u00a7cTeleport cancelled: you moved.");
                return;
            }
            if (--w.ticks <= 0) {
                this.pending.remove(p.getUUID());
                w.task.run();
                return;
            }
            this.schedule(server, p);
        });
    }

    private static final class W {
        final Runnable task;
        final double x;
        final double y;
        final double z;
        int ticks;
        boolean cancelOnMove;
        boolean cancelOnDamage;

        W(Runnable t, double x, double y, double z, int ticks, boolean onMove, boolean onDamage) {
            this.task = t;
            this.x = x;
            this.y = y;
            this.z = z;
            this.ticks = ticks;
            this.cancelOnMove = onMove;
            this.cancelOnDamage = onDamage;
        }
    }
}

