/*
 * Decompiled with CFR 0.152.
 */
package com.alphine.mysticessentials.util;

import com.alphine.mysticessentials.MysticEssentialsCommon;
import com.alphine.mysticessentials.perm.Perms;
import com.alphine.mysticessentials.util.AfkService;
import java.util.regex.Pattern;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public final class AfkPingUtil {
    private AfkPingUtil() {
    }

    public static void handleChatMention(MinecraftServer server, ServerPlayer sender, String rawMessage) {
        if (rawMessage == null || rawMessage.isBlank()) {
            return;
        }
        MysticEssentialsCommon common = MysticEssentialsCommon.get();
        AfkService afk = common.afk;
        if (afk == null) {
            return;
        }
        for (ServerPlayer target : server.getPlayerList().getPlayers()) {
            String base;
            String name;
            if (target.getUUID().equals(sender.getUUID()) || !AfkPingUtil.containsWholeWordIgnoreCase(rawMessage, name = target.getGameProfile().getName()) || !afk.isAfk(target.getUUID()) || Perms.has(target, "messentials.afk.message.exempt", 0)) continue;
            String msg = base = common.cfg.afk.defaultMessage == null ? "I'm currently AFK." : common.cfg.afk.defaultMessage;
            if (Perms.has(sender, "messentials.afk.message.use", 0)) {
                msg = afk.currentAfkMessage(target.getUUID()).orElse(base);
            }
            String out = afk.formatNotify(sender.getGameProfile().getName(), name, msg);
            sender.displayClientMessage((Component)Component.literal((String)out), false);
        }
    }

    private static boolean containsWholeWordIgnoreCase(String haystack, String word) {
        String w = Pattern.quote(word);
        Pattern p = Pattern.compile("(?i)(^|\\W)" + w + "(\\W|$)");
        return p.matcher(haystack).find();
    }
}

